/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.AggregateNotFoundException;
import org.axonframework.commandhandling.model.AggregateRolledBackException;
import org.axonframework.commandhandling.model.AggregateScopeDescriptor;
import org.axonframework.commandhandling.model.ConflictingAggregateVersionException;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository<T, A extends Aggregate<T>>
implements Repository<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepository.class);
    private final String aggregatesKey = this + "_AGGREGATES";
    private final AggregateModel<T> aggregateModel;

    protected AbstractRepository(Class<T> aggregateType) {
        this(AnnotatedAggregateMetaModelFactory.inspectAggregate(Assert.nonNull(aggregateType, () -> "aggregateType may not be null")));
    }

    protected AbstractRepository(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory) {
        this(AnnotatedAggregateMetaModelFactory.inspectAggregate(Assert.nonNull(aggregateType, () -> "aggregateType may not be null"), Assert.nonNull(parameterResolverFactory, () -> "parameterResolverFactory may not be null")));
    }

    protected AbstractRepository(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this(AnnotatedAggregateMetaModelFactory.inspectAggregate(Assert.nonNull(aggregateType, () -> "aggregateType may not be null"), Assert.nonNull(parameterResolverFactory, () -> "parameterResolverFactory may not be null"), Assert.nonNull(handlerDefinition, () -> "handler definition may not be null")));
    }

    protected AbstractRepository(AggregateModel<T> aggregateModel) {
        Assert.notNull(aggregateModel, () -> "aggregateModel may not be null");
        this.aggregateModel = aggregateModel;
    }

    public A newInstance(Callable<T> factoryMethod) throws Exception {
        UnitOfWork<?> uow = CurrentUnitOfWork.get();
        AtomicReference<A> aggregateReference = new AtomicReference<A>();
        uow.onPrepareCommit(x -> this.prepareForCommit((Aggregate)aggregateReference.get()));
        Object aggregate = this.doCreateNew(factoryMethod);
        aggregateReference.set(aggregate);
        Assert.isTrue(this.aggregateModel.entityClass().isAssignableFrom(aggregate.rootType()), () -> "Unsuitable aggregate for this repository: wrong type");
        Map aggregates = this.managedAggregates(uow);
        Assert.isTrue(aggregates.putIfAbsent(aggregate.identifierAsString(), aggregate) == null, () -> "The Unit of Work already has an Aggregate with the same identifier");
        uow.onRollback(u -> {
            Aggregate cfr_ignored_0 = (Aggregate)aggregates.remove(aggregate.identifierAsString());
        });
        return aggregate;
    }

    protected abstract A doCreateNew(Callable<T> var1) throws Exception;

    public A load(String aggregateIdentifier, Long expectedVersion) {
        UnitOfWork<?> uow = CurrentUnitOfWork.get();
        Map aggregates = this.managedAggregates(uow);
        Aggregate aggregate = aggregates.computeIfAbsent(aggregateIdentifier, s -> this.doLoad(aggregateIdentifier, expectedVersion));
        uow.onRollback(u -> {
            Aggregate cfr_ignored_0 = (Aggregate)aggregates.remove(aggregateIdentifier);
        });
        this.validateOnLoad(aggregate, expectedVersion);
        this.prepareForCommit(aggregate);
        return (A)aggregate;
    }

    protected Map<String, A> managedAggregates(UnitOfWork<?> uow) {
        return uow.root().getOrComputeResource(this.aggregatesKey, s -> new HashMap());
    }

    public A load(String aggregateIdentifier) {
        return this.load(aggregateIdentifier, null);
    }

    protected void validateOnLoad(Aggregate<T> aggregate, Long expectedVersion) {
        if (expectedVersion != null && aggregate.version() != null && !expectedVersion.equals(aggregate.version())) {
            throw new ConflictingAggregateVersionException(aggregate.identifierAsString(), expectedVersion, aggregate.version());
        }
    }

    protected void prepareForCommit(A aggregate) {
        if (UnitOfWork.Phase.STARTED.isBefore(CurrentUnitOfWork.get().phase())) {
            this.doCommit(aggregate);
        } else {
            CurrentUnitOfWork.get().onPrepareCommit(u -> this.doCommit(aggregate));
        }
    }

    private void doCommit(A aggregate) {
        if (this.managedAggregates(CurrentUnitOfWork.get()).containsValue(aggregate)) {
            if (aggregate.isDeleted()) {
                this.doDelete(aggregate);
            } else {
                this.doSave(aggregate);
            }
            if (aggregate.isDeleted()) {
                this.postDelete(aggregate);
            } else {
                this.postSave(aggregate);
            }
        } else {
            this.reportIllegalState(aggregate);
        }
    }

    protected void reportIllegalState(A aggregate) {
        throw new AggregateRolledBackException(aggregate.identifierAsString());
    }

    protected AggregateModel<T> aggregateModel() {
        return this.aggregateModel;
    }

    protected Class<? extends T> getAggregateType() {
        return this.aggregateModel.entityClass();
    }

    protected abstract void doSave(A var1);

    protected abstract A doLoad(String var1, Long var2);

    protected abstract void doDelete(A var1);

    protected void postSave(A aggregate) {
    }

    protected void postDelete(A aggregate) {
    }

    @Override
    public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
        if (this.canResolve(scopeDescription)) {
            String aggregateIdentifier = ((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString();
            try {
                this.load(aggregateIdentifier).handle(message);
            }
            catch (AggregateNotFoundException e) {
                logger.debug("Aggregate (with id: [{}]) cannot be loaded. Hence, message '[{}]' cannot be handled.", (Object)aggregateIdentifier, message);
            }
        }
    }

    @Override
    public boolean canResolve(ScopeDescriptor scopeDescription) {
        return scopeDescription instanceof AggregateScopeDescriptor && Objects.equals(this.aggregateModel.type(), ((AggregateScopeDescriptor)scopeDescription).getType());
    }
}

