/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class RetryingCallback<C, R>
implements CommandCallback<C, R> {
    private final CommandCallback<C, R> delegate;
    private final RetryScheduler retryScheduler;
    private final CommandBus commandBus;
    private final List<Class<? extends Throwable>[]> history;

    public RetryingCallback(CommandCallback<C, R> delegate, RetryScheduler retryScheduler, CommandBus commandBus) {
        this.delegate = delegate;
        this.retryScheduler = retryScheduler;
        this.commandBus = commandBus;
        this.history = new ArrayList<Class<? extends Throwable>[]>();
    }

    @Override
    public void onSuccess(CommandMessage<? extends C> commandMessage, R result) {
        this.delegate.onSuccess(commandMessage, result);
    }

    @Override
    public void onFailure(CommandMessage<? extends C> commandMessage, Throwable cause) {
        this.history.add(this.simplify(cause));
        try {
            if (!(cause instanceof RuntimeException) || this.isCausedBy(cause, DeadlockException.class) && CurrentUnitOfWork.isStarted() || !this.retryScheduler.scheduleRetry(commandMessage, (RuntimeException)cause, new ArrayList<Class<? extends Throwable>[]>(this.history), new RetryDispatch(commandMessage))) {
                this.delegate.onFailure(commandMessage, cause);
            }
        }
        catch (Exception e) {
            this.delegate.onFailure(commandMessage, e);
        }
    }

    private boolean isCausedBy(Throwable exception, Class<? extends Throwable> causeType) {
        return causeType.isInstance(exception) || exception.getCause() != null && this.isCausedBy(exception.getCause(), causeType);
    }

    private Class<? extends Throwable>[] simplify(Throwable cause) {
        ArrayList types = new ArrayList();
        types.add(cause.getClass());
        Throwable rootCause = cause;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
            types.add(rootCause.getClass());
        }
        return types.toArray(new Class[0]);
    }

    private class RetryDispatch
    implements Runnable {
        private final CommandMessage<? extends C> commandMessage;

        private RetryDispatch(CommandMessage<? extends C> commandMessage) {
            this.commandMessage = commandMessage;
        }

        @Override
        public void run() {
            try {
                RetryingCallback.this.commandBus.dispatch(this.commandMessage, RetryingCallback.this);
            }
            catch (Exception e) {
                RetryingCallback.this.onFailure(this.commandMessage, e);
            }
        }
    }
}

