/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.callbacks.FailureLoggingCallback;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.commandhandling.gateway.AbstractCommandGateway;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandGateway
extends AbstractCommandGateway
implements CommandGateway {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommandGateway.class);

    @SafeVarargs
    public DefaultCommandGateway(CommandBus commandBus, MessageDispatchInterceptor<? super CommandMessage<?>> ... messageDispatchInterceptors) {
        this(commandBus, (RetryScheduler)null, messageDispatchInterceptors);
    }

    @SafeVarargs
    public DefaultCommandGateway(CommandBus commandBus, RetryScheduler retryScheduler, MessageDispatchInterceptor<? super CommandMessage<?>> ... messageDispatchInterceptors) {
        this(commandBus, retryScheduler, Arrays.asList(messageDispatchInterceptors));
    }

    public DefaultCommandGateway(CommandBus commandBus, RetryScheduler retryScheduler, List<MessageDispatchInterceptor<? super CommandMessage<?>>> messageDispatchInterceptors) {
        super(commandBus, retryScheduler, messageDispatchInterceptors);
    }

    @Override
    public <C, R> void send(C command, CommandCallback<? super C, R> callback) {
        super.send(command, callback);
    }

    @Override
    public <R> R sendAndWait(Object command) {
        FutureCallback futureCallback = new FutureCallback();
        this.send(command, futureCallback);
        return futureCallback.getResult();
    }

    @Override
    public <R> R sendAndWait(Object command, long timeout, TimeUnit unit) {
        FutureCallback futureCallback = new FutureCallback();
        this.send(command, futureCallback);
        return futureCallback.getResult(timeout, unit);
    }

    @Override
    public <R> CompletableFuture<R> send(Object command) {
        FutureCallback callback = new FutureCallback();
        this.send(command, new FailureLoggingCallback(logger, callback));
        return callback;
    }
}

