/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.commandhandling.gateway.AbstractCommandGateway;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.commandhandling.gateway.Timeout;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.MetaDataValue;

public class CommandGatewayFactory {
    private final CommandBus commandBus;
    private final RetryScheduler retryScheduler;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;
    private final List<CommandCallback<?, ?>> commandCallbacks;

    @SafeVarargs
    public CommandGatewayFactory(CommandBus commandBus, MessageDispatchInterceptor<CommandMessage<?>> ... dispatchInterceptors) {
        this(commandBus, (RetryScheduler)null, dispatchInterceptors);
    }

    @SafeVarargs
    public CommandGatewayFactory(CommandBus commandBus, RetryScheduler retryScheduler, MessageDispatchInterceptor<CommandMessage<?>> ... messageDispatchInterceptors) {
        this(commandBus, retryScheduler, Arrays.asList(messageDispatchInterceptors));
    }

    public CommandGatewayFactory(CommandBus commandBus, RetryScheduler retryScheduler, List<MessageDispatchInterceptor<CommandMessage<?>>> messageDispatchInterceptors) {
        Assert.notNull(commandBus, () -> "commandBus may not be null");
        this.retryScheduler = retryScheduler;
        this.commandBus = commandBus;
        this.dispatchInterceptors = messageDispatchInterceptors != null && !messageDispatchInterceptors.isEmpty() ? new CopyOnWriteArrayList(messageDispatchInterceptors) : new CopyOnWriteArrayList();
        this.commandCallbacks = new CopyOnWriteArrayList();
    }

    public <T> T createGateway(Class<T> gatewayInterface) {
        HashMap<Method, InvocationHandler> dispatchers = new HashMap<Method, InvocationHandler>();
        for (Method gatewayMethod : gatewayInterface.getMethods()) {
            MetaDataExtractor[] extractors = this.extractMetaData(gatewayMethod.getParameters());
            Class<?>[] arguments = gatewayMethod.getParameterTypes();
            InvocationHandler dispatcher = new DispatchOnInvocationHandler(this.commandBus, this.retryScheduler, this.dispatchInterceptors, extractors, this.commandCallbacks, true);
            if (!Arrays.asList(CompletableFuture.class, Future.class, CompletionStage.class).contains(gatewayMethod.getReturnType())) {
                if (arguments.length >= 3 && TimeUnit.class.isAssignableFrom(arguments[arguments.length - 1]) && (Long.TYPE.isAssignableFrom(arguments[arguments.length - 2]) || Integer.TYPE.isAssignableFrom(arguments[arguments.length - 2]))) {
                    dispatcher = this.wrapToReturnWithTimeoutInArguments(dispatcher, arguments.length - 2, arguments.length - 1);
                } else {
                    Map timeout = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)gatewayMethod, Timeout.class).orElse(AnnotationUtils.findAnnotationAttributes(gatewayMethod.getDeclaringClass(), Timeout.class).orElse(null));
                    if (timeout != null) {
                        dispatcher = this.wrapToReturnWithFixedTimeout(dispatcher, ((Integer)timeout.get("timeout")).intValue(), (TimeUnit)((Object)timeout.get("unit")));
                    } else if (!Void.TYPE.equals(gatewayMethod.getReturnType()) || gatewayMethod.getExceptionTypes().length > 0) {
                        dispatcher = this.wrapToWaitForResult(dispatcher);
                    } else if (this.commandCallbacks.isEmpty() && !this.hasCallbackParameters(gatewayMethod)) {
                        dispatcher = this.wrapToFireAndForget(new DispatchOnInvocationHandler(this.commandBus, this.retryScheduler, this.dispatchInterceptors, extractors, this.commandCallbacks, false));
                    }
                }
                Class<?>[] declaredExceptions = gatewayMethod.getExceptionTypes();
                if (!this.contains(declaredExceptions, TimeoutException.class)) {
                    dispatcher = this.wrapToReturnNullOnTimeout(dispatcher);
                }
                if (!this.contains(declaredExceptions, InterruptedException.class)) {
                    dispatcher = this.wrapToReturnNullOnInterrupted(dispatcher);
                }
                dispatcher = this.wrapUndeclaredExceptions(dispatcher, declaredExceptions);
            }
            dispatchers.put(gatewayMethod, dispatcher);
        }
        return gatewayInterface.cast(Proxy.newProxyInstance(gatewayInterface.getClassLoader(), new Class[]{gatewayInterface}, (java.lang.reflect.InvocationHandler)new GatewayInvocationHandler(dispatchers, this.commandBus, this.retryScheduler, this.dispatchInterceptors)));
    }

    private boolean hasCallbackParameters(Method gatewayMethod) {
        for (Class<?> parameter : gatewayMethod.getParameterTypes()) {
            if (!CommandCallback.class.isAssignableFrom(parameter)) continue;
            return true;
        }
        return false;
    }

    protected <R> InvocationHandler<R> wrapUndeclaredExceptions(InvocationHandler<R> delegate, Class<?>[] declaredExceptions) {
        return new WrapNonDeclaredCheckedExceptions(delegate, declaredExceptions);
    }

    protected <R> InvocationHandler<R> wrapToReturnNullOnInterrupted(InvocationHandler<R> delegate) {
        return new NullOnInterrupted(delegate);
    }

    protected <R> InvocationHandler<R> wrapToReturnNullOnTimeout(InvocationHandler<R> delegate) {
        return new NullOnTimeout(delegate);
    }

    protected <R> InvocationHandler<R> wrapToFireAndForget(InvocationHandler<CompletableFuture<R>> delegate) {
        return new FireAndForget(delegate);
    }

    protected <R> InvocationHandler<R> wrapToWaitForResult(InvocationHandler<CompletableFuture<R>> delegate) {
        return new WaitForResult(delegate);
    }

    protected <R> InvocationHandler<R> wrapToReturnWithFixedTimeout(InvocationHandler<CompletableFuture<R>> delegate, long timeout, TimeUnit timeUnit) {
        return new WaitForResultWithFixedTimeout(delegate, timeout, timeUnit);
    }

    protected <R> InvocationHandler<R> wrapToReturnWithTimeoutInArguments(InvocationHandler<CompletableFuture<R>> delegate, int timeoutIndex, int timeUnitIndex) {
        return new WaitForResultWithTimeoutInArguments(delegate, timeoutIndex, timeUnitIndex);
    }

    private boolean contains(Class<?>[] declaredExceptions, Class<?> exceptionClass) {
        for (Class<?> declaredException : declaredExceptions) {
            if (!declaredException.isAssignableFrom(exceptionClass)) continue;
            return true;
        }
        return false;
    }

    public <C, R> CommandGatewayFactory registerCommandCallback(CommandCallback<C, R> callback) {
        this.commandCallbacks.add(new TypeSafeCallbackWrapper<C, R>(callback));
        return this;
    }

    public CommandGatewayFactory registerDispatchInterceptor(MessageDispatchInterceptor<CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return this;
    }

    private MetaDataExtractor[] extractMetaData(Parameter[] parameters) {
        ArrayList<MetaDataExtractor> extractors = new ArrayList<MetaDataExtractor>();
        for (int i = 0; i < parameters.length; ++i) {
            if (MetaData.class.isAssignableFrom(parameters[i].getType())) {
                extractors.add(new MetaDataExtractor(i, null));
                continue;
            }
            Optional<Map<String, Object>> metaDataAnnotation = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)parameters[i], MetaDataValue.class);
            if (!metaDataAnnotation.isPresent()) continue;
            extractors.add(new MetaDataExtractor(i, (String)metaDataAnnotation.get().get("metaDataValue")));
        }
        return extractors.toArray(new MetaDataExtractor[0]);
    }

    private static class TypeSafeCallbackWrapper<C, R>
    implements CommandCallback<C, Object> {
        private final CommandCallback<C, R> delegate;
        private final Class<R> parameterType;

        public TypeSafeCallbackWrapper(CommandCallback<C, R> delegate) {
            Method m;
            this.delegate = delegate;
            Class discoveredParameterType = Object.class;
            Iterator<Method> iterator = ReflectionUtils.methodsOf(delegate.getClass()).iterator();
            while (!(!iterator.hasNext() || (m = iterator.next()).getGenericParameterTypes().length == 2 && m.getGenericParameterTypes()[1] != Object.class && "onSuccess".equals(m.getName()) && Modifier.isPublic(m.getModifiers()) && (discoveredParameterType = m.getParameterTypes()[1]) != Object.class)) {
            }
            this.parameterType = discoveredParameterType;
        }

        @Override
        public void onSuccess(CommandMessage<? extends C> commandMessage, Object result) {
            if (this.parameterType.isInstance(result) || !this.parameterType.isPrimitive() && result == null) {
                this.delegate.onSuccess(commandMessage, this.parameterType.cast(result));
            }
        }

        @Override
        public void onFailure(CommandMessage<? extends C> commandMessage, Throwable cause) {
            this.delegate.onFailure(commandMessage, cause);
        }
    }

    private static class MetaDataExtractor {
        private final int argumentIndex;
        private final String metaDataKey;

        private MetaDataExtractor(int argumentIndex, String metaDataKey) {
            this.argumentIndex = argumentIndex;
            this.metaDataKey = metaDataKey;
        }

        public void addMetaData(Object[] args, Map<String, Object> metaData) {
            Object parameterValue = args[this.argumentIndex];
            if (this.metaDataKey == null) {
                if (parameterValue != null) {
                    metaData.putAll((Map)parameterValue);
                }
            } else {
                metaData.put(this.metaDataKey, parameterValue);
            }
        }
    }

    private static class FireAndForget<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;

        private FireAndForget(InvocationHandler<CompletableFuture<R>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            this.delegate.invoke(proxy, invokedMethod, args);
            return null;
        }
    }

    private static class WaitForResult<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;

        private WaitForResult(InvocationHandler<CompletableFuture<R>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            return this.delegate.invoke(proxy, invokedMethod, args).get();
        }
    }

    private static class WaitForResultWithTimeoutInArguments<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;
        private final int timeoutIndex;
        private final int timeUnitIndex;

        private WaitForResultWithTimeoutInArguments(InvocationHandler<CompletableFuture<R>> delegate, int timeoutIndex, int timeUnitIndex) {
            this.delegate = delegate;
            this.timeoutIndex = timeoutIndex;
            this.timeUnitIndex = timeUnitIndex;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            return this.delegate.invoke(proxy, invokedMethod, args).get(this.toLong(args[this.timeoutIndex]), (TimeUnit)((Object)args[this.timeUnitIndex]));
        }

        private long toLong(Object arg) {
            if (Integer.TYPE.isInstance(arg) || Integer.class.isInstance(arg)) {
                return ((Integer)arg).intValue();
            }
            return (Long)arg;
        }
    }

    private static class WaitForResultWithFixedTimeout<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;
        private final long timeout;
        private final TimeUnit timeUnit;

        private WaitForResultWithFixedTimeout(InvocationHandler<CompletableFuture<R>> delegate, long timeout, TimeUnit timeUnit) {
            this.delegate = delegate;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            return this.delegate.invoke(proxy, invokedMethod, args).get(this.timeout, this.timeUnit);
        }
    }

    private static class NullOnInterrupted<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<R> delegate;

        private NullOnInterrupted(InvocationHandler<R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            try {
                return this.delegate.invoke(proxy, invokedMethod, args);
            }
            catch (InterruptedException timeout) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    private static class NullOnTimeout<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<R> delegate;

        private NullOnTimeout(InvocationHandler<R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            try {
                return this.delegate.invoke(proxy, invokedMethod, args);
            }
            catch (TimeoutException timeout) {
                return null;
            }
        }
    }

    private static final class WrapNonDeclaredCheckedExceptions<R>
    implements InvocationHandler<R> {
        private final Class<?>[] declaredExceptions;
        private final InvocationHandler<R> delegate;

        private WrapNonDeclaredCheckedExceptions(InvocationHandler<R> delegate, Class<?>[] declaredExceptions) {
            this.delegate = delegate;
            this.declaredExceptions = declaredExceptions;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            try {
                return this.delegate.invoke(proxy, invokedMethod, args);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                for (Class<?> exception : this.declaredExceptions) {
                    if (!exception.isInstance(cause)) continue;
                    throw cause instanceof Exception ? (Exception)cause : e;
                }
                throw new CommandExecutionException("Command execution resulted in a checked exception that was not declared on the gateway", cause);
            }
        }
    }

    private static class CompositeCallback<C, R>
    implements CommandCallback<C, R> {
        private final List<CommandCallback<? super C, ? super R>> callbacks;

        public CompositeCallback(List<CommandCallback<? super C, ? super R>> callbacks) {
            this.callbacks = new ArrayList<CommandCallback<C, R>>(callbacks);
        }

        @Override
        public void onSuccess(CommandMessage<? extends C> commandMessage, R result) {
            for (CommandCallback<? extends C, R> commandCallback : this.callbacks) {
                commandCallback.onSuccess(commandMessage, result);
            }
        }

        @Override
        public void onFailure(CommandMessage<? extends C> commandMessage, Throwable cause) {
            for (CommandCallback<? extends C, R> commandCallback : this.callbacks) {
                commandCallback.onFailure(commandMessage, cause);
            }
        }
    }

    private static class DispatchOnInvocationHandler<C, R>
    extends AbstractCommandGateway
    implements InvocationHandler<CompletableFuture<R>> {
        private final MetaDataExtractor[] metaDataExtractors;
        private final List<CommandCallback<? super C, ? super R>> commandCallbacks;
        private final boolean forceCallbacks;

        protected DispatchOnInvocationHandler(CommandBus commandBus, RetryScheduler retryScheduler, List<MessageDispatchInterceptor<? super CommandMessage<?>>> messageDispatchInterceptors, MetaDataExtractor[] metaDataExtractors, List<CommandCallback<? super C, ? super R>> commandCallbacks, boolean forceCallbacks) {
            super(commandBus, retryScheduler, messageDispatchInterceptors);
            this.metaDataExtractors = metaDataExtractors;
            this.commandCallbacks = commandCallbacks;
            this.forceCallbacks = forceCallbacks;
        }

        @Override
        public CompletableFuture<R> invoke(Object proxy, Method invokedMethod, Object[] args) {
            Object command = args[0];
            if (this.metaDataExtractors.length != 0) {
                HashMap<String, Object> metaDataValues = new HashMap<String, Object>();
                for (MetaDataExtractor extractor : this.metaDataExtractors) {
                    extractor.addMetaData(args, metaDataValues);
                }
                if (!metaDataValues.isEmpty()) {
                    command = GenericCommandMessage.asCommandMessage(command).withMetaData(metaDataValues);
                }
            }
            if (this.forceCallbacks || !this.commandCallbacks.isEmpty()) {
                LinkedList callbacks = new LinkedList();
                FutureCallback future = new FutureCallback();
                callbacks.add(future);
                for (Object arg : args) {
                    if (!(arg instanceof CommandCallback)) continue;
                    CommandCallback callback = (CommandCallback)arg;
                    callbacks.add(callback);
                }
                callbacks.addAll(this.commandCallbacks);
                this.send(command, new CompositeCallback(callbacks));
                return future;
            }
            this.sendAndForget(command);
            return null;
        }
    }

    private static class GatewayInvocationHandler
    extends AbstractCommandGateway
    implements java.lang.reflect.InvocationHandler {
        private final Map<Method, InvocationHandler> dispatchers;

        public GatewayInvocationHandler(Map<Method, InvocationHandler> dispatchers, CommandBus commandBus, RetryScheduler retryScheduler, List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors) {
            super(commandBus, retryScheduler, dispatchInterceptors);
            this.dispatchers = new HashMap<Method, InvocationHandler>(dispatchers);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            InvocationHandler invocationHandler = this.dispatchers.get(method);
            return invocationHandler.invoke(proxy, method, args);
        }
    }

    public static interface InvocationHandler<R> {
        public R invoke(Object var1, Method var2, Object[] var3) throws Exception;
    }
}

