/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.callbacks.LoggingCallback;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.commandhandling.gateway.RetryingCallback;
import org.axonframework.common.Assert;
import org.axonframework.messaging.MessageDispatchInterceptor;

public abstract class AbstractCommandGateway {
    private final CommandBus commandBus;
    private final RetryScheduler retryScheduler;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;

    protected AbstractCommandGateway(CommandBus commandBus, RetryScheduler retryScheduler, List<MessageDispatchInterceptor<? super CommandMessage<?>>> messageDispatchInterceptors) {
        Assert.notNull(commandBus, () -> "commandBus may not be null");
        this.commandBus = commandBus;
        this.dispatchInterceptors = messageDispatchInterceptors != null && !messageDispatchInterceptors.isEmpty() ? new ArrayList(messageDispatchInterceptors) : Collections.emptyList();
        this.retryScheduler = retryScheduler;
    }

    protected <C, R> void send(C command, CommandCallback<? super C, R> callback) {
        CommandMessage commandMessage = this.processInterceptors(GenericCommandMessage.asCommandMessage(command));
        CommandCallback<? super C, R> commandCallback = callback;
        if (this.retryScheduler != null) {
            commandCallback = new RetryingCallback<C, R>(callback, this.retryScheduler, this.commandBus);
        }
        this.commandBus.dispatch(commandMessage, commandCallback);
    }

    protected void sendAndForget(Object command) {
        if (this.retryScheduler == null) {
            this.commandBus.dispatch(this.processInterceptors(GenericCommandMessage.asCommandMessage(command)));
        } else {
            CommandMessage commandMessage = GenericCommandMessage.asCommandMessage(command);
            this.send(commandMessage, LoggingCallback.INSTANCE);
        }
    }

    protected <C> CommandMessage<? extends C> processInterceptors(CommandMessage<C> commandMessage) {
        CommandMessage<C> message = commandMessage;
        for (MessageDispatchInterceptor<CommandMessage<?>> dispatchInterceptor : this.dispatchInterceptors) {
            message = dispatchInterceptor.handle(message);
        }
        return message;
    }

    public CommandBus getCommandBus() {
        return this.commandBus;
    }
}

