/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Arrays;
import java.util.Objects;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public abstract class ReplyMessage {
    protected String commandIdentifier;
    protected boolean success;
    protected String resultType;
    protected String resultRevision;
    protected byte[] serializedResult;

    protected ReplyMessage() {
    }

    public ReplyMessage(String commandIdentifier, boolean success, Object returnValue, Serializer serializer) {
        this.success = success;
        SerializedObject<byte[]> result = returnValue == null ? null : serializer.serialize(returnValue, byte[].class);
        this.commandIdentifier = commandIdentifier;
        if (result != null) {
            this.resultType = result.getType().getName();
            this.resultRevision = result.getType().getRevision();
            this.serializedResult = result.getData();
        }
    }

    public Object getReturnValue(Serializer serializer) {
        if (!this.success || this.resultType == null) {
            return null;
        }
        return this.deserializeResult(serializer);
    }

    public Throwable getError(Serializer serializer) {
        if (this.success || this.resultType == null) {
            return null;
        }
        return (Throwable)this.deserializeResult(serializer);
    }

    private Object deserializeResult(Serializer serializer) {
        return serializer.deserialize(new SimpleSerializedObject<byte[]>(this.serializedResult, byte[].class, this.resultType, this.resultRevision));
    }

    public String getCommandIdentifier() {
        return this.commandIdentifier;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getResultType() {
        return this.resultType;
    }

    public String getResultRevision() {
        return this.resultRevision;
    }

    public byte[] getSerializedResult() {
        return this.serializedResult;
    }

    public int hashCode() {
        return Objects.hash(this.commandIdentifier, this.success, this.resultType, this.resultRevision, this.serializedResult);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReplyMessage other = (ReplyMessage)obj;
        return Objects.equals(this.commandIdentifier, other.commandIdentifier) && Objects.equals(this.success, other.success) && Objects.equals(this.resultType, other.resultType) && Objects.equals(this.resultRevision, other.resultRevision) && Objects.deepEquals(this.serializedResult, other.serializedResult);
    }

    public String toString() {
        return "ReplyMessage{commandIdentifier='" + this.commandIdentifier + '\'' + ", success=" + this.success + ", resultType='" + this.resultType + '\'' + ", resultRevision='" + this.resultRevision + '\'' + ", serializedResult=" + Arrays.toString(this.serializedResult) + '}';
    }
}

