/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.MonitorAwareCallback;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.commandhandling.distributed.commandfilter.CommandNameFilter;
import org.axonframework.commandhandling.distributed.commandfilter.DenyAll;
import org.axonframework.commandhandling.distributed.commandfilter.DenyCommandNameFilter;
import org.axonframework.common.Assert;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;

public class DistributedCommandBus
implements CommandBus {
    public static final int INITIAL_LOAD_FACTOR = 100;
    private static final String DISPATCH_ERROR_MESSAGE = "An error occurred while trying to dispatch a command on the DistributedCommandBus";
    private final CommandRouter commandRouter;
    private final CommandBusConnector connector;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final AtomicReference<Predicate<CommandMessage<?>>> commandFilter = new AtomicReference<DenyAll>(DenyAll.INSTANCE);
    private final MessageMonitor<? super CommandMessage<?>> messageMonitor;
    private volatile int loadFactor = 100;

    public DistributedCommandBus(CommandRouter commandRouter, CommandBusConnector connector) {
        this(commandRouter, connector, NoOpMessageMonitor.INSTANCE);
    }

    public DistributedCommandBus(CommandRouter commandRouter, CommandBusConnector connector, MessageMonitor<? super CommandMessage<?>> messageMonitor) {
        Assert.notNull(commandRouter, () -> "serviceRegistry may not be null");
        Assert.notNull(connector, () -> "connector may not be null");
        Assert.notNull(messageMonitor, () -> "messageMonitor may not be null");
        this.commandRouter = commandRouter;
        this.connector = connector;
        this.messageMonitor = messageMonitor;
    }

    @Override
    public <C> void dispatch(CommandMessage<C> command) {
        if (NoOpMessageMonitor.INSTANCE.equals(this.messageMonitor)) {
            CommandMessage interceptedCommand = this.intercept(command);
            Member destination = this.commandRouter.findDestination(interceptedCommand).orElseThrow(() -> new NoHandlerForCommandException(String.format("No node known to accept [%s]", interceptedCommand.getCommandName())));
            try {
                this.connector.send(destination, interceptedCommand);
            }
            catch (Exception e) {
                destination.suspect();
                throw new CommandDispatchException("An error occurred while trying to dispatch a command on the DistributedCommandBus: " + e.getMessage(), e);
            }
        } else {
            this.dispatch(command, null);
        }
    }

    @Override
    public <C, R> void dispatch(CommandMessage<C> command, CommandCallback<? super C, R> callback) {
        CommandMessage interceptedCommand = this.intercept(command);
        MessageMonitor.MonitorCallback messageMonitorCallback = this.messageMonitor.onMessageIngested(interceptedCommand);
        Member destination = this.commandRouter.findDestination(interceptedCommand).orElseThrow(() -> {
            NoHandlerForCommandException exception = new NoHandlerForCommandException(String.format("No node known to accept [%s]", interceptedCommand.getCommandName()));
            messageMonitorCallback.reportFailure(exception);
            return exception;
        });
        try {
            this.connector.send(destination, interceptedCommand, new MonitorAwareCallback<C, R>(callback, messageMonitorCallback));
        }
        catch (Exception e) {
            messageMonitorCallback.reportFailure(e);
            destination.suspect();
            throw new CommandDispatchException("An error occurred while trying to dispatch a command on the DistributedCommandBus: " + e.getMessage(), e);
        }
    }

    private <C> CommandMessage<? extends C> intercept(CommandMessage<C> command) {
        CommandMessage<C> interceptedCommand = command;
        for (MessageDispatchInterceptor<CommandMessage<?>> interceptor : this.dispatchInterceptors) {
            interceptedCommand = interceptor.handle(interceptedCommand);
        }
        return interceptedCommand;
    }

    @Override
    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> handler) {
        Registration reg = this.connector.subscribe(commandName, handler);
        this.updateFilter(this.commandFilter.get().or(new CommandNameFilter(commandName)));
        return () -> {
            this.updateFilter(this.commandFilter.get().and(new DenyCommandNameFilter(commandName)));
            return reg.cancel();
        };
    }

    private void updateFilter(Predicate<CommandMessage<?>> newFilter) {
        if (!this.commandFilter.getAndSet(newFilter).equals(newFilter)) {
            this.commandRouter.updateMembership(this.loadFactor, newFilter);
        }
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public void updateLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
        this.commandRouter.updateMembership(loadFactor, this.commandFilter.get());
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return this.connector.registerHandlerInterceptor(handlerInterceptor);
    }
}

