/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.common.Assert;
import org.axonframework.common.digest.Digester;

public class ConsistentHash {
    private final SortedMap<String, ConsistentHashMember> hashToMember;
    private final int modCount;
    private final Function<String, String> hashFunction;
    private final Map<String, ConsistentHashMember> members;

    public ConsistentHash() {
        this(ConsistentHash::hash);
    }

    public ConsistentHash(Function<String, String> hashFunction) {
        this.hashToMember = Collections.emptySortedMap();
        this.members = Collections.emptyMap();
        this.modCount = 0;
        this.hashFunction = hashFunction;
    }

    private ConsistentHash(Map<String, ConsistentHashMember> members, Function<String, String> hashFunction, int modCount) {
        this.hashFunction = hashFunction;
        this.modCount = modCount;
        this.hashToMember = new TreeMap<String, ConsistentHashMember>();
        this.members = members;
        members.values().forEach(m -> m.hashes().forEach(h -> this.hashToMember.put((String)h, (ConsistentHashMember)m)));
    }

    protected static String hash(String routingKey) {
        return Digester.md5Hex(routingKey);
    }

    public Collection<ConsistentHashMember> getEligibleMembers(String routingKey) {
        String hash = ConsistentHash.hash(routingKey);
        Collection<ConsistentHashMember> tail = this.hashToMember.tailMap(hash).values();
        Collection<ConsistentHashMember> head = this.hashToMember.headMap(hash).values();
        LinkedHashSet<ConsistentHashMember> combined = new LinkedHashSet<ConsistentHashMember>(tail);
        combined.addAll(head);
        return combined;
    }

    public Optional<Member> getMember(String routingKey, CommandMessage<?> commandMessage) {
        String hash = ConsistentHash.hash(routingKey);
        SortedMap<String, ConsistentHashMember> tailMap = this.hashToMember.tailMap(hash);
        Iterator<Map.Entry<String, ConsistentHashMember>> tailIterator = tailMap.entrySet().iterator();
        Optional<Member> foundMember = this.findSuitableMember(commandMessage, tailIterator);
        if (!foundMember.isPresent()) {
            Iterator<Map.Entry<String, ConsistentHashMember>> headIterator = this.hashToMember.headMap(hash).entrySet().iterator();
            foundMember = this.findSuitableMember(commandMessage, headIterator);
        }
        return foundMember;
    }

    private Optional<Member> findSuitableMember(CommandMessage<?> commandMessage, Iterator<Map.Entry<String, ConsistentHashMember>> iterator) {
        while (iterator.hasNext()) {
            Map.Entry<String, ConsistentHashMember> entry = iterator.next();
            if (!entry.getValue().commandFilter.test(commandMessage)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Set<Member> getMembers() {
        return new HashSet<Member>(this.members.values());
    }

    public ConsistentHash with(Member member, int loadFactor, Predicate<? super CommandMessage<?>> commandFilter) {
        Assert.notNull(member, () -> "Member may not be null");
        ConsistentHashMember newMember = new ConsistentHashMember(member, loadFactor, commandFilter);
        if (this.members.containsKey(member.name()) && newMember.equals(this.members.get(member.name()))) {
            return this;
        }
        TreeMap<String, ConsistentHashMember> newMembers = new TreeMap<String, ConsistentHashMember>(this.members);
        newMembers.put(member.name(), newMember);
        return new ConsistentHash(newMembers, this.hashFunction, this.modCount + 1);
    }

    public ConsistentHash without(Member member) {
        Assert.notNull(member, () -> "Member may not be null");
        if (!this.members.containsKey(member.name())) {
            return this;
        }
        TreeMap<String, ConsistentHashMember> newMembers = new TreeMap<String, ConsistentHashMember>(this.members);
        newMembers.remove(member.name());
        return new ConsistentHash(newMembers, this.hashFunction, this.modCount + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsistentHash that = (ConsistentHash)o;
        return Objects.equals(this.hashToMember, that.hashToMember);
    }

    public int hashCode() {
        return Objects.hash(this.hashToMember);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConsistentHash [");
        Collection<ConsistentHashMember> members = this.members.values();
        members.forEach(m -> sb.append(m.toString()).append(","));
        if (!members.isEmpty()) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append("]");
        return sb.toString();
    }

    public int version() {
        return this.modCount;
    }

    public static class ConsistentHashMember
    implements Member {
        private final Member member;
        private final int segmentCount;
        private final Predicate<? super CommandMessage<?>> commandFilter;

        private ConsistentHashMember(Member member, int segmentCount, Predicate<? super CommandMessage<?>> commandFilter) {
            this.member = member instanceof ConsistentHashMember ? ((ConsistentHashMember)member).member : member;
            this.segmentCount = segmentCount;
            this.commandFilter = commandFilter;
        }

        @Override
        public String name() {
            return this.member.name();
        }

        @Override
        public boolean local() {
            return this.member.local();
        }

        @Override
        public void suspect() {
            this.member.suspect();
        }

        public int segmentCount() {
            return this.segmentCount;
        }

        public Predicate<? super CommandMessage<?>> getCommandFilter() {
            return this.commandFilter;
        }

        public Set<String> hashes() {
            TreeSet<String> newHashes = new TreeSet<String>();
            for (int t = 0; t < this.segmentCount; ++t) {
                String hash = ConsistentHash.hash(this.name() + " #" + t);
                newHashes.add(hash);
            }
            return newHashes;
        }

        @Override
        public <T> Optional<T> getConnectionEndpoint(Class<T> protocol) {
            return this.member.getConnectionEndpoint(protocol);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsistentHashMember that = (ConsistentHashMember)o;
            return this.segmentCount == that.segmentCount && Objects.equals(this.member, that.member) && Objects.equals(this.commandFilter, that.commandFilter);
        }

        public int hashCode() {
            return Objects.hash(this.member, this.segmentCount, this.commandFilter);
        }

        public String toString() {
            return this.member.name() + "(" + this.segmentCount + ")";
        }
    }
}

