/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;

public class CommandCallbackWrapper<A, C, R>
implements CommandCallback<C, R> {
    private final CommandCallback<? super C, R> wrapped;
    private final A sessionId;
    private final CommandMessage<C> message;

    public CommandCallbackWrapper(A channelId, CommandMessage<C> message, CommandCallback<? super C, R> callback) {
        this.wrapped = callback;
        this.sessionId = channelId;
        this.message = message;
    }

    public CommandMessage<C> getMessage() {
        return this.message;
    }

    public A getChannelIdentifier() {
        return this.sessionId;
    }

    public void fail(Throwable e) {
        this.onFailure(this.getMessage(), e);
    }

    public void success(R result) {
        this.onSuccess(this.getMessage(), result);
    }

    @Override
    public void onSuccess(CommandMessage<? extends C> message, R result) {
        this.wrapped.onSuccess(message, result);
    }

    @Override
    public void onFailure(CommandMessage<? extends C> message, Throwable cause) {
        this.wrapped.onFailure(message, cause);
    }
}

