/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.TargetAggregateIdentifier;
import org.axonframework.commandhandling.distributed.AbstractRoutingStrategy;
import org.axonframework.commandhandling.distributed.UnresolvedRoutingKeyPolicy;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;

public class AnnotationRoutingStrategy
extends AbstractRoutingStrategy {
    private static final AggregateIdentifierResolver NO_RESOLVE = new AggregateIdentifierResolver((Method)null);
    private final Class<? extends Annotation> annotationType;
    private final Map<Class<?>, AggregateIdentifierResolver> resolverMap = new ConcurrentHashMap();

    public AnnotationRoutingStrategy() {
        this(TargetAggregateIdentifier.class);
    }

    public AnnotationRoutingStrategy(Class<? extends Annotation> annotationType) {
        this(annotationType, UnresolvedRoutingKeyPolicy.ERROR);
    }

    public AnnotationRoutingStrategy(UnresolvedRoutingKeyPolicy unresolvedRoutingKeyPolicy) {
        this(TargetAggregateIdentifier.class, unresolvedRoutingKeyPolicy);
    }

    public AnnotationRoutingStrategy(Class<? extends Annotation> annotationType, UnresolvedRoutingKeyPolicy unresolvedRoutingKeyPolicy) {
        super(unresolvedRoutingKeyPolicy);
        this.annotationType = annotationType;
    }

    @Override
    protected String doResolveRoutingKey(CommandMessage<?> command) {
        String aggregateIdentifier;
        try {
            aggregateIdentifier = this.findIdentifier(command);
        }
        catch (InvocationTargetException e) {
            throw new AxonConfigurationException("An exception occurred while extracting aggregate information form a command", e);
        }
        catch (IllegalAccessException e) {
            throw new AxonConfigurationException("The current security context does not allow extraction of aggregate information from the given command.", e);
        }
        return aggregateIdentifier;
    }

    private String findIdentifier(CommandMessage<?> command) throws InvocationTargetException, IllegalAccessException {
        return this.resolverMap.computeIfAbsent(command.getPayloadType(), this::createResolver).identify(command.getPayload());
    }

    private AggregateIdentifierResolver createResolver(Class<?> type) {
        for (Method m : ReflectionUtils.methodsOf(type)) {
            if (!m.isAnnotationPresent(this.annotationType)) continue;
            ReflectionUtils.ensureAccessible(m);
            return new AggregateIdentifierResolver(m);
        }
        for (Field f : ReflectionUtils.fieldsOf(type)) {
            if (!f.isAnnotationPresent(this.annotationType)) continue;
            return new AggregateIdentifierResolver(f);
        }
        return NO_RESOLVE;
    }

    private static final class AggregateIdentifierResolver {
        private final Method method;
        private final Field field;

        public AggregateIdentifierResolver(Method method) {
            this.method = method;
            this.field = null;
        }

        public AggregateIdentifierResolver(Field field) {
            this.method = null;
            this.field = field;
        }

        public String identify(Object command) throws InvocationTargetException, IllegalAccessException {
            if (this.method != null) {
                return Objects.toString(this.method.invoke(command, new Object[0]));
            }
            if (this.field != null) {
                return Objects.toString(ReflectionUtils.getFieldValue(this.field, command));
            }
            return null;
        }
    }
}

