/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import com.lmax.disruptor.EventHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.disruptor.AggregateBlacklistedException;
import org.axonframework.commandhandling.disruptor.AggregateStateCorruptedException;
import org.axonframework.commandhandling.disruptor.CommandHandlingEntry;
import org.axonframework.commandhandling.disruptor.DisruptorCommandBus;
import org.axonframework.commandhandling.disruptor.DisruptorUnitOfWork;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPublisher
implements EventHandler<CommandHandlingEntry> {
    private static final Logger logger = LoggerFactory.getLogger(DisruptorCommandBus.class);
    private final Executor executor;
    private final RollbackConfiguration rollbackConfiguration;
    private final int segmentId;
    private final Set<Object> blackListedAggregates = new HashSet<Object>();
    private final TransactionManager transactionManager;

    public EventPublisher(Executor executor, TransactionManager transactionManager, RollbackConfiguration rollbackConfiguration, int segmentId) {
        this.executor = executor;
        this.transactionManager = transactionManager;
        this.rollbackConfiguration = rollbackConfiguration;
        this.segmentId = segmentId;
    }

    public void onEvent(CommandHandlingEntry entry, long sequence, boolean endOfBatch) {
        if (entry.isRecoverEntry()) {
            this.recoverAggregate(entry);
        } else if (entry.getPublisherId() == this.segmentId) {
            entry.resume();
            String aggregateIdentifier = entry.getAggregateIdentifier();
            if (aggregateIdentifier != null && this.blackListedAggregates.contains(aggregateIdentifier)) {
                this.rejectExecution(entry, aggregateIdentifier);
            } else {
                this.processPublication(entry, entry, aggregateIdentifier);
            }
        }
    }

    private void recoverAggregate(CommandHandlingEntry entry) {
        if (this.blackListedAggregates.remove(entry.getAggregateIdentifier())) {
            logger.info("Reset notification for {} received. The aggregate is removed from the blacklist", (Object)entry.getAggregateIdentifier());
        }
    }

    private void rejectExecution(CommandHandlingEntry entry, String aggregateIdentifier) {
        this.executor.execute(new ReportResultTask((CommandMessage)entry.getMessage(), entry.getCallback(), null, new AggregateStateCorruptedException(aggregateIdentifier, String.format("Aggregate %s has been blacklisted and will be ignored until its state has been recovered.", aggregateIdentifier))));
        entry.rollback(entry.getExceptionResult());
    }

    private void processPublication(CommandHandlingEntry entry, DisruptorUnitOfWork unitOfWork, String aggregateIdentifier) {
        this.invokeInterceptorChain(entry);
        Throwable exceptionResult = entry.getExceptionResult() != null && this.rollbackConfiguration.rollBackOn(entry.getExceptionResult()) ? this.performRollback(unitOfWork, aggregateIdentifier, entry.getExceptionResult()) : this.performCommit(unitOfWork, entry.getExceptionResult(), aggregateIdentifier);
        if (exceptionResult != null || entry.getCallback().hasDelegate()) {
            this.executor.execute(new ReportResultTask((CommandMessage)entry.getMessage(), entry.getCallback(), entry.getResult(), exceptionResult));
        }
    }

    private void invokeInterceptorChain(CommandHandlingEntry entry) {
        try {
            entry.setResult(entry.getPublisherInterceptorChain().proceed());
        }
        catch (Exception throwable) {
            entry.setExceptionResult(throwable);
        }
    }

    private Throwable performRollback(DisruptorUnitOfWork unitOfWork, String aggregateIdentifier, Throwable exceptionResult) {
        unitOfWork.rollback(exceptionResult);
        if (aggregateIdentifier != null) {
            return this.notifyBlacklisted(unitOfWork, aggregateIdentifier, exceptionResult);
        }
        return exceptionResult;
    }

    private Throwable performCommit(DisruptorUnitOfWork unitOfWork, Throwable exceptionResult, String aggregateIdentifier) {
        try {
            if (exceptionResult != null && this.rollbackConfiguration.rollBackOn(exceptionResult)) {
                unitOfWork.rollback(exceptionResult);
            } else {
                if (this.transactionManager != null) {
                    unitOfWork.attachTransaction(this.transactionManager);
                }
                unitOfWork.commit();
            }
        }
        catch (Exception e) {
            if (unitOfWork.isActive()) {
                unitOfWork.rollback(e);
            }
            if (aggregateIdentifier != null) {
                return this.notifyBlacklisted(unitOfWork, aggregateIdentifier, e);
            }
            return e;
        }
        return exceptionResult;
    }

    private Throwable notifyBlacklisted(DisruptorUnitOfWork unitOfWork, String aggregateIdentifier, Throwable cause) {
        this.blackListedAggregates.add(aggregateIdentifier);
        AggregateBlacklistedException exceptionResult = new AggregateBlacklistedException(aggregateIdentifier, String.format("Aggregate %s state corrupted. Blacklisting the aggregate until a reset message has been received", aggregateIdentifier), cause);
        if (unitOfWork.isActive()) {
            unitOfWork.rollback(exceptionResult);
        }
        return exceptionResult;
    }

    private static class ReportResultTask<C, R>
    implements Runnable {
        private final CommandMessage<C> commandMessage;
        private final CommandCallback<C, R> callback;
        private final R result;
        private final Throwable exceptionResult;

        private ReportResultTask(CommandMessage<C> commandMessage, CommandCallback<C, R> callback, R result, Throwable exceptionResult) {
            this.commandMessage = commandMessage;
            this.callback = callback;
            this.result = result;
            this.exceptionResult = exceptionResult;
        }

        @Override
        public void run() {
            if (this.exceptionResult != null) {
                this.callback.onFailure(this.commandMessage, this.exceptionResult);
            } else {
                this.callback.onSuccess(this.commandMessage, this.result);
            }
        }
    }
}

