/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.AbstractUnitOfWork;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.MessageProcessingContext;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public abstract class DisruptorUnitOfWork<T extends Message<?>>
extends AbstractUnitOfWork<T> {
    private MessageProcessingContext<T> processingContext;

    public void reset(T message) {
        if (this.processingContext == null) {
            this.processingContext = new MessageProcessingContext<T>(message);
        } else {
            this.processingContext.reset(message);
        }
        this.setPhase(UnitOfWork.Phase.NOT_STARTED);
        this.resources().clear();
        this.correlationDataProviders().clear();
    }

    public void pause() {
        CurrentUnitOfWork.clear(this);
    }

    public void resume() {
        CurrentUnitOfWork.set(this);
    }

    @Override
    public Optional<UnitOfWork<?>> parent() {
        return Optional.empty();
    }

    @Override
    public T getMessage() {
        return this.processingContext.getMessage();
    }

    @Override
    public UnitOfWork<T> transformMessage(Function<T, ? extends Message<?>> transformOperator) {
        this.processingContext.transformMessage(transformOperator);
        return this;
    }

    @Override
    protected void notifyHandlers(UnitOfWork.Phase phase) {
        this.processingContext.notifyHandlers(this, phase);
    }

    @Override
    protected void addHandler(UnitOfWork.Phase phase, Consumer<UnitOfWork<T>> handler) {
        this.processingContext.addHandler(phase, handler);
    }

    @Override
    protected void setExecutionResult(ExecutionResult executionResult) {
        this.processingContext.setExecutionResult(executionResult);
    }

    @Override
    protected void setRollbackCause(Throwable cause) {
        this.setExecutionResult(new ExecutionResult(cause));
    }

    @Override
    public <R> R executeWithResult(Callable<R> task, RollbackConfiguration rollbackConfiguration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutionResult getExecutionResult() {
        return this.processingContext.getExecutionResult();
    }
}

