/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.axonframework.commandhandling.AnnotationCommandTargetResolver;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.common.Assert;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.caching.NoCache;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.serialization.Serializer;

public class DisruptorConfiguration {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private int bufferSize = 4096;
    private ProducerType producerType;
    private WaitStrategy waitStrategy;
    private Executor executor;
    private RollbackConfiguration rollbackConfiguration;
    private boolean rescheduleCommandsOnCorruptState = true;
    private long coolingDownPeriod = 1000L;
    private Cache cache;
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> invokerInterceptors = new ArrayList();
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> publisherInterceptors = new ArrayList();
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new ArrayList();
    private TransactionManager transactionManager;
    private CommandTargetResolver commandTargetResolver;
    private int invokerThreadCount = 1;
    private int publisherThreadCount = 1;
    private Serializer serializer;
    private MessageMonitor<? super CommandMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;

    public DisruptorConfiguration() {
        this.producerType = ProducerType.MULTI;
        this.waitStrategy = new BlockingWaitStrategy();
        this.cache = NoCache.INSTANCE;
        this.rollbackConfiguration = RollbackConfigurationType.UNCHECKED_EXCEPTIONS;
        this.commandTargetResolver = new AnnotationCommandTargetResolver();
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public DisruptorConfiguration setWaitStrategy(WaitStrategy waitStrategy) {
        Assert.notNull(waitStrategy, () -> "waitStrategy must not be null");
        this.waitStrategy = waitStrategy;
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public DisruptorConfiguration setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public List<MessageHandlerInterceptor<? super CommandMessage<?>>> getInvokerInterceptors() {
        return this.invokerInterceptors;
    }

    public DisruptorConfiguration setInvokerInterceptors(List<MessageHandlerInterceptor<? super CommandMessage<?>>> invokerInterceptors) {
        this.invokerInterceptors.clear();
        this.invokerInterceptors.addAll(invokerInterceptors);
        return this;
    }

    public List<MessageHandlerInterceptor<? super CommandMessage<?>>> getPublisherInterceptors() {
        return this.publisherInterceptors;
    }

    public DisruptorConfiguration setPublisherInterceptors(List<MessageHandlerInterceptor<CommandMessage<?>>> publisherInterceptors) {
        this.publisherInterceptors.clear();
        this.publisherInterceptors.addAll(publisherInterceptors);
        return this;
    }

    public List<MessageDispatchInterceptor<? super CommandMessage<?>>> getDispatchInterceptors() {
        return this.dispatchInterceptors;
    }

    public DisruptorConfiguration setDispatchInterceptors(List<MessageDispatchInterceptor<CommandMessage<?>>> dispatchInterceptors) {
        this.dispatchInterceptors.clear();
        this.dispatchInterceptors.addAll(dispatchInterceptors);
        return this;
    }

    public RollbackConfiguration getRollbackConfiguration() {
        return this.rollbackConfiguration;
    }

    public DisruptorConfiguration setRollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
        Assert.notNull(rollbackConfiguration, () -> "rollbackConfiguration may not be null");
        this.rollbackConfiguration = rollbackConfiguration;
        return this;
    }

    public boolean getRescheduleCommandsOnCorruptState() {
        return this.rescheduleCommandsOnCorruptState;
    }

    public DisruptorConfiguration setRescheduleCommandsOnCorruptState(boolean rescheduleCommandsOnCorruptState) {
        this.rescheduleCommandsOnCorruptState = rescheduleCommandsOnCorruptState;
        return this;
    }

    public long getCoolingDownPeriod() {
        return this.coolingDownPeriod;
    }

    public DisruptorConfiguration setCoolingDownPeriod(long coolingDownPeriod) {
        this.coolingDownPeriod = coolingDownPeriod;
        return this;
    }

    public Cache getCache() {
        return this.cache;
    }

    public DisruptorConfiguration setCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public CommandTargetResolver getCommandTargetResolver() {
        return this.commandTargetResolver;
    }

    public DisruptorConfiguration setCommandTargetResolver(CommandTargetResolver newCommandTargetResolver) {
        Assert.notNull(newCommandTargetResolver, () -> "newCommandTargetResolver may not be null");
        this.commandTargetResolver = newCommandTargetResolver;
        return this;
    }

    public int getInvokerThreadCount() {
        return this.invokerThreadCount;
    }

    public DisruptorConfiguration setInvokerThreadCount(int count) {
        Assert.isTrue(count > 0, () -> "InvokerCount must be at least 1");
        this.invokerThreadCount = count;
        return this;
    }

    public int getPublisherThreadCount() {
        return this.publisherThreadCount;
    }

    public DisruptorConfiguration setPublisherThreadCount(int count) {
        Assert.isTrue(count > 0, () -> "PublisherCount must be at least 1");
        this.publisherThreadCount = count;
        return this;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public DisruptorConfiguration setSerializer(Serializer newSerializer) {
        this.serializer = newSerializer;
        return this;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public DisruptorConfiguration setTransactionManager(TransactionManager newTransactionManager) {
        this.transactionManager = newTransactionManager;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public DisruptorConfiguration setBufferSize(int newBufferSize) {
        this.bufferSize = newBufferSize;
        return this;
    }

    public ProducerType getProducerType() {
        return this.producerType;
    }

    public DisruptorConfiguration setProducerType(ProducerType producerType) {
        Assert.notNull(producerType, () -> "producerType must not be null");
        this.producerType = producerType;
        return this;
    }

    public MessageMonitor<? super CommandMessage<?>> getMessageMonitor() {
        return this.messageMonitor;
    }

    public DisruptorConfiguration setMessageMonitor(MessageMonitor<? super CommandMessage<?>> messageMonitor) {
        Assert.notNull(messageMonitor, () -> "messageMonitor must not be null");
        this.messageMonitor = messageMonitor;
        return this;
    }
}

