/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.MonitorAwareCallback;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.disruptor.BlacklistDetectingCallback;
import org.axonframework.commandhandling.disruptor.CommandHandlerInvoker;
import org.axonframework.commandhandling.disruptor.CommandHandlingEntry;
import org.axonframework.commandhandling.disruptor.DisruptorConfiguration;
import org.axonframework.commandhandling.disruptor.EventPublisher;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.AggregateNotFoundException;
import org.axonframework.commandhandling.model.AggregateScopeDescriptor;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.Registration;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.monitoring.MessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorCommandBus
implements CommandBus {
    private static final Logger logger = LoggerFactory.getLogger(DisruptorCommandBus.class);
    private final ConcurrentMap<String, MessageHandler<? super CommandMessage<?>>> commandHandlers = new ConcurrentHashMap();
    private final Disruptor<CommandHandlingEntry> disruptor;
    private final CommandHandlerInvoker[] commandHandlerInvokers;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> invokerInterceptors;
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> publisherInterceptors;
    private final ExecutorService executorService;
    private final boolean rescheduleOnCorruptState;
    private final long coolingDownPeriod;
    private final CommandTargetResolver commandTargetResolver;
    private final int publisherCount;
    private final MessageMonitor<? super CommandMessage<?>> messageMonitor;
    private final EventStore eventStore;
    private volatile boolean started = true;
    private volatile boolean disruptorShutDown = false;

    @Deprecated
    public DisruptorCommandBus(EventStore eventStore) {
        this(eventStore, new DisruptorConfiguration());
    }

    public DisruptorCommandBus() {
        this(null, new DisruptorConfiguration());
    }

    public DisruptorCommandBus(DisruptorConfiguration configuration) {
        this(null, configuration);
    }

    @Deprecated
    public DisruptorCommandBus(EventStore eventStore, DisruptorConfiguration configuration) {
        this.eventStore = eventStore;
        Assert.notNull(configuration, () -> "configuration may not be null");
        Executor executor = configuration.getExecutor();
        if (executor == null) {
            this.executorService = Executors.newCachedThreadPool(new AxonThreadFactory("DisruptorCommandBus"));
            executor = this.executorService;
        } else {
            this.executorService = null;
        }
        this.rescheduleOnCorruptState = configuration.getRescheduleCommandsOnCorruptState();
        this.invokerInterceptors = new CopyOnWriteArrayList(configuration.getInvokerInterceptors());
        this.publisherInterceptors = new ArrayList(configuration.getPublisherInterceptors());
        this.dispatchInterceptors = new CopyOnWriteArrayList(configuration.getDispatchInterceptors());
        TransactionManager transactionManager = configuration.getTransactionManager();
        this.disruptor = new Disruptor(CommandHandlingEntry::new, configuration.getBufferSize(), executor, configuration.getProducerType(), configuration.getWaitStrategy());
        this.commandTargetResolver = configuration.getCommandTargetResolver();
        this.commandHandlerInvokers = this.initializeInvokerThreads(configuration);
        EventHandler[] publishers = this.initializePublisherThreads(configuration, executor, transactionManager);
        this.messageMonitor = configuration.getMessageMonitor();
        this.publisherCount = publishers.length;
        this.disruptor.setDefaultExceptionHandler((com.lmax.disruptor.ExceptionHandler)new ExceptionHandler());
        this.disruptor.handleEventsWith((EventHandler[])this.commandHandlerInvokers).then(publishers);
        this.coolingDownPeriod = configuration.getCoolingDownPeriod();
        this.disruptor.start();
    }

    private EventPublisher[] initializePublisherThreads(DisruptorConfiguration configuration, Executor executor, TransactionManager transactionManager) {
        EventPublisher[] publishers = new EventPublisher[configuration.getPublisherThreadCount()];
        for (int t = 0; t < publishers.length; ++t) {
            publishers[t] = new EventPublisher(executor, transactionManager, configuration.getRollbackConfiguration(), t);
        }
        return publishers;
    }

    private CommandHandlerInvoker[] initializeInvokerThreads(DisruptorConfiguration configuration) {
        CommandHandlerInvoker[] invokers = new CommandHandlerInvoker[configuration.getInvokerThreadCount()];
        for (int t = 0; t < invokers.length; ++t) {
            invokers[t] = new CommandHandlerInvoker(configuration.getCache(), t);
        }
        return invokers;
    }

    @Override
    public <C> void dispatch(CommandMessage<C> command) {
        this.dispatch(command, FailureLoggingCommandCallback.INSTANCE);
    }

    @Override
    public <C, R> void dispatch(CommandMessage<C> command, CommandCallback<? super C, R> callback) {
        Assert.state(this.started, () -> "CommandBus has been shut down. It is not accepting any Commands");
        CommandMessage<C> commandToDispatch = command;
        for (MessageDispatchInterceptor<CommandMessage<?>> interceptor : this.dispatchInterceptors) {
            commandToDispatch = interceptor.handle(commandToDispatch);
        }
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(commandToDispatch);
        try {
            this.doDispatch(commandToDispatch, new MonitorAwareCallback<C, R>(callback, monitorCallback));
        }
        catch (Exception e) {
            monitorCallback.reportFailure(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C, R> void doDispatch(CommandMessage<? extends C> command, CommandCallback<? super C, R> callback) {
        String aggregateIdentifier;
        Assert.state(!this.disruptorShutDown, () -> "Disruptor has been shut down. Cannot dispatch or re-dispatch commands");
        MessageHandler commandHandler = (MessageHandler)this.commandHandlers.get(command.getCommandName());
        if (commandHandler == null) {
            throw new NoHandlerForCommandException(String.format("No handler was subscribed to command [%s]", command.getCommandName()));
        }
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        int invokerSegment = 0;
        int publisherSegment = 0;
        if ((this.commandHandlerInvokers.length > 1 || this.publisherCount > 1) && (aggregateIdentifier = this.commandTargetResolver.resolveTarget(command).getIdentifier()) != null) {
            int idHash = aggregateIdentifier.hashCode() & Integer.MAX_VALUE;
            if (this.commandHandlerInvokers.length > 1) {
                invokerSegment = idHash % this.commandHandlerInvokers.length;
            }
            if (this.publisherCount > 1) {
                publisherSegment = idHash % this.publisherCount;
            }
        }
        long sequence = ringBuffer.next();
        try {
            CommandHandlingEntry event = (CommandHandlingEntry)ringBuffer.get(sequence);
            event.reset(command, commandHandler, invokerSegment, publisherSegment, new BlacklistDetectingCallback(callback, (RingBuffer<CommandHandlingEntry>)this.disruptor.getRingBuffer(), this::doDispatch, this.rescheduleOnCorruptState), this.invokerInterceptors, this.publisherInterceptors);
        }
        finally {
            ringBuffer.publish(sequence);
        }
    }

    @Deprecated
    public <T> Repository<T> createRepository(AggregateFactory<T> aggregateFactory) {
        return this.createRepository(aggregateFactory, NoSnapshotTriggerDefinition.INSTANCE);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory) {
        return this.createRepository(eventStore, aggregateFactory, NoSnapshotTriggerDefinition.INSTANCE);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, RepositoryProvider repositoryProvider) {
        return this.createRepository(eventStore, aggregateFactory, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, repositoryProvider);
    }

    @Deprecated
    public <T> Repository<T> createRepository(AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        return this.createRepository(aggregateFactory, snapshotTriggerDefinition, ClasspathParameterResolverFactory.forClass(aggregateFactory.getAggregateType()));
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        return this.createRepository(eventStore, aggregateFactory, snapshotTriggerDefinition, ClasspathParameterResolverFactory.forClass(aggregateFactory.getAggregateType()));
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        return this.createRepository(eventStore, aggregateFactory, snapshotTriggerDefinition, ClasspathParameterResolverFactory.forClass(aggregateFactory.getAggregateType()), ClasspathHandlerDefinition.forClass(aggregateFactory.getAggregateType()), repositoryProvider);
    }

    @Deprecated
    public <T> Repository<T> createRepository(AggregateFactory<T> aggregateFactory, ParameterResolverFactory parameterResolverFactory) {
        return this.createRepository(aggregateFactory, NoSnapshotTriggerDefinition.INSTANCE, parameterResolverFactory);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, ParameterResolverFactory parameterResolverFactory) {
        return this.createRepository(eventStore, aggregateFactory, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, parameterResolverFactory);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, RepositoryProvider repositoryProvider) {
        return this.createRepository(eventStore, aggregateFactory, NoSnapshotTriggerDefinition.INSTANCE, parameterResolverFactory, handlerDefinition, repositoryProvider);
    }

    @Deprecated
    public <T> Repository<T> createRepository(AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, ParameterResolverFactory parameterResolverFactory) {
        return this.createRepository(this.eventStore, aggregateFactory, snapshotTriggerDefinition, parameterResolverFactory);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, ParameterResolverFactory parameterResolverFactory) {
        return this.createRepository(eventStore, aggregateFactory, snapshotTriggerDefinition, parameterResolverFactory, ClasspathHandlerDefinition.forClass(aggregateFactory.getAggregateType()), null);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, RepositoryProvider repositoryProvider) {
        for (CommandHandlerInvoker invoker : this.commandHandlerInvokers) {
            invoker.createRepository(eventStore, repositoryProvider, aggregateFactory, snapshotTriggerDefinition, parameterResolverFactory, handlerDefinition);
        }
        return new DisruptorRepository<T>(aggregateFactory.getAggregateType());
    }

    @Override
    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> handler) {
        this.commandHandlers.put(commandName, handler);
        return () -> this.commandHandlers.remove(commandName, handler);
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        long lastChangeDetected = System.currentTimeMillis();
        long lastKnownCursor = this.disruptor.getRingBuffer().getCursor();
        while (System.currentTimeMillis() - lastChangeDetected < this.coolingDownPeriod && !Thread.interrupted()) {
            if (this.disruptor.getRingBuffer().getCursor() == lastKnownCursor) continue;
            lastChangeDetected = System.currentTimeMillis();
            lastKnownCursor = this.disruptor.getRingBuffer().getCursor();
        }
        this.disruptorShutDown = true;
        this.disruptor.shutdown();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        this.invokerInterceptors.add(handlerInterceptor);
        return () -> this.invokerInterceptors.remove(handlerInterceptor);
    }

    private class ExceptionHandler
    implements com.lmax.disruptor.ExceptionHandler {
        private ExceptionHandler() {
        }

        public void handleEventException(Throwable ex, long sequence, Object event) {
            logger.error("Exception occurred while processing a {}.", (Object)((CommandMessage)((CommandHandlingEntry)event).getMessage()).getPayloadType().getSimpleName(), (Object)ex);
        }

        public void handleOnStartException(Throwable ex) {
            logger.error("Failed to start the DisruptorCommandBus.", ex);
            DisruptorCommandBus.this.disruptor.shutdown();
        }

        public void handleOnShutdownException(Throwable ex) {
            logger.error("Error while shutting down the DisruptorCommandBus", ex);
        }
    }

    private class DisruptorRepository<T>
    implements Repository<T> {
        private final Class<T> type;

        public DisruptorRepository(Class<T> type) {
            this.type = type;
        }

        @Override
        public Aggregate<T> load(String aggregateIdentifier, Long expectedVersion) {
            return CommandHandlerInvoker.getRepository(this.type).load(aggregateIdentifier, expectedVersion);
        }

        @Override
        public Aggregate<T> load(String aggregateIdentifier) {
            return CommandHandlerInvoker.getRepository(this.type).load(aggregateIdentifier);
        }

        @Override
        public Aggregate<T> newInstance(Callable<T> factoryMethod) throws Exception {
            return CommandHandlerInvoker.getRepository(this.type).newInstance(factoryMethod);
        }

        @Override
        public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
            CompletableFuture future = new CompletableFuture();
            this.send(message, scopeDescription, future);
            try {
                future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(final Message<?> message, ScopeDescriptor scopeDescription, final CompletableFuture<?> future) {
            if (!this.canResolve(scopeDescription)) {
                future.complete(null);
                return;
            }
            final String aggregateIdentifier = ((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString();
            RingBuffer ringBuffer = DisruptorCommandBus.this.disruptor.getRingBuffer();
            int invokerSegment = 0;
            int publisherSegment = 0;
            if ((DisruptorCommandBus.this.commandHandlerInvokers.length > 1 || DisruptorCommandBus.this.publisherCount > 1) && aggregateIdentifier != null) {
                int idHash = aggregateIdentifier.hashCode() & Integer.MAX_VALUE;
                if (DisruptorCommandBus.this.commandHandlerInvokers.length > 1) {
                    invokerSegment = idHash % DisruptorCommandBus.this.commandHandlerInvokers.length;
                }
                if (DisruptorCommandBus.this.publisherCount > 1) {
                    publisherSegment = idHash % DisruptorCommandBus.this.publisherCount;
                }
            }
            long sequence = ringBuffer.next();
            try {
                CommandHandlingEntry event = (CommandHandlingEntry)ringBuffer.get(sequence);
                event.resetAsCallable(() -> {
                    try {
                        return this.load(aggregateIdentifier).handle(message);
                    }
                    catch (AggregateNotFoundException e) {
                        logger.debug("Aggregate (with id: [{}]) cannot be loaded. Hence, message '[{}]' cannot be handled.", (Object)aggregateIdentifier, (Object)message);
                        return null;
                    }
                }, invokerSegment, publisherSegment, new BlacklistDetectingCallback(new CommandCallback<Object, Object>(){

                    @Override
                    public void onSuccess(CommandMessage<?> commandMessage, Object result) {
                        future.complete(null);
                    }

                    @Override
                    public void onFailure(CommandMessage<?> commandMessage, Throwable cause) {
                        logger.warn("Failed sending message [{}] to aggregate with id [{}]", (Object)message, (Object)aggregateIdentifier);
                        future.completeExceptionally(cause);
                    }
                }, (RingBuffer<CommandHandlingEntry>)DisruptorCommandBus.this.disruptor.getRingBuffer(), (commandMessage, callback) -> this.send(message, scopeDescription, future), DisruptorCommandBus.this.rescheduleOnCorruptState));
            }
            finally {
                ringBuffer.publish(sequence);
            }
        }

        @Override
        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return scopeDescription instanceof AggregateScopeDescriptor && Objects.equals(this.type.getSimpleName(), ((AggregateScopeDescriptor)scopeDescription).getType());
        }
    }

    private static class FailureLoggingCommandCallback
    implements CommandCallback<Object, Object> {
        private static final FailureLoggingCommandCallback INSTANCE = new FailureLoggingCommandCallback();

        private FailureLoggingCommandCallback() {
        }

        @Override
        public void onSuccess(CommandMessage<?> commandMessage, Object result) {
        }

        @Override
        public void onFailure(CommandMessage<?> commandMessage, Throwable cause) {
            logger.info("An error occurred while handling a command [{}].", (Object)commandMessage.getCommandName(), (Object)cause);
        }
    }
}

