/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import com.lmax.disruptor.RingBuffer;
import java.util.function.BiConsumer;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.disruptor.AggregateBlacklistedException;
import org.axonframework.commandhandling.disruptor.AggregateStateCorruptedException;
import org.axonframework.commandhandling.disruptor.CommandHandlingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistDetectingCallback<C, R>
implements CommandCallback<C, R> {
    private static final Logger logger = LoggerFactory.getLogger(BlacklistDetectingCallback.class);
    private final CommandCallback<? super C, R> delegate;
    private final RingBuffer<CommandHandlingEntry> ringBuffer;
    private final BiConsumer<CommandMessage<? extends C>, CommandCallback<? super C, R>> retryMethod;
    private final boolean rescheduleOnCorruptState;

    public BlacklistDetectingCallback(CommandCallback<? super C, R> delegate, RingBuffer<CommandHandlingEntry> ringBuffer, BiConsumer<CommandMessage<? extends C>, CommandCallback<? super C, R>> retryMethod, boolean rescheduleOnCorruptState) {
        this.delegate = delegate;
        this.ringBuffer = ringBuffer;
        this.retryMethod = retryMethod;
        this.rescheduleOnCorruptState = rescheduleOnCorruptState;
    }

    @Override
    public void onSuccess(CommandMessage<? extends C> commandMessage, R result) {
        if (this.delegate != null) {
            this.delegate.onSuccess(commandMessage, result);
        }
    }

    @Override
    public void onFailure(CommandMessage<? extends C> command, Throwable cause) {
        if (cause instanceof AggregateBlacklistedException) {
            long sequence = this.ringBuffer.next();
            CommandHandlingEntry event = (CommandHandlingEntry)this.ringBuffer.get(sequence);
            event.resetAsRecoverEntry(((AggregateBlacklistedException)cause).getAggregateIdentifier());
            this.ringBuffer.publish(sequence);
            if (this.delegate != null) {
                this.delegate.onFailure(command, cause.getCause());
            }
        } else if (this.rescheduleOnCorruptState && cause instanceof AggregateStateCorruptedException) {
            this.retryMethod.accept(command, this.delegate);
        } else if (this.delegate != null) {
            this.delegate.onFailure(command, cause);
        } else {
            logger.warn("Command {} resulted in an exception:", (Object)command.getPayloadType().getSimpleName(), (Object)cause);
        }
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }
}

