/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.conflictresolution;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.conflictresolution.ConflictResolver;
import org.axonframework.commandhandling.conflictresolution.NoConflictResolver;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class ConflictResolution
implements ParameterResolverFactory,
ParameterResolver<ConflictResolver> {
    private static final String CONFLICT_RESOLUTION_KEY = ConflictResolution.class.getName();

    public static void initialize(ConflictResolver conflictResolver) {
        Assert.state(CurrentUnitOfWork.isStarted(), () -> "An active Unit of Work is required for conflict resolution");
        CurrentUnitOfWork.get().getOrComputeResource(CONFLICT_RESOLUTION_KEY, key -> conflictResolver);
    }

    public static ConflictResolver getConflictResolver() {
        return CurrentUnitOfWork.map(uow -> {
            ConflictResolver conflictResolver = (ConflictResolver)uow.getResource(CONFLICT_RESOLUTION_KEY);
            return conflictResolver == null ? NoConflictResolver.INSTANCE : conflictResolver;
        }).orElse(NoConflictResolver.INSTANCE);
    }

    @Override
    public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (ConflictResolver.class.equals(parameters[parameterIndex].getType())) {
            return this;
        }
        return null;
    }

    @Override
    public ConflictResolver resolveParameterValue(Message<?> message) {
        return ConflictResolution.getConflictResolver();
    }

    @Override
    public boolean matches(Message<?> message) {
        return message instanceof CommandMessage;
    }
}

