/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.callbacks;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;

public class FutureCallback<C, R>
extends CompletableFuture<R>
implements CommandCallback<C, R> {
    @Override
    public void onSuccess(CommandMessage<? extends C> commandMessage, R executionResult) {
        super.complete(executionResult);
    }

    @Override
    public void onFailure(CommandMessage commandMessage, Throwable cause) {
        super.completeExceptionally(Objects.requireNonNull(cause));
    }

    public R getResult() {
        try {
            return (R)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw this.asRuntime(e);
        }
    }

    public R getResult(long timeout, TimeUnit unit) {
        try {
            return (R)this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw this.asRuntime(e);
        }
    }

    private RuntimeException asRuntime(Exception e) {
        Throwable failure = e.getCause();
        if (failure instanceof Error) {
            throw (Error)failure;
        }
        if (failure instanceof RuntimeException) {
            return (RuntimeException)failure;
        }
        return new CommandExecutionException("An exception occurred while executing a command", failure);
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) {
        try {
            this.get(timeout, unit);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }
}

