/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.callbacks;

import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureLoggingCallback<C, R>
implements CommandCallback<C, R> {
    private final CommandCallback<C, R> delegate;
    private final Logger logger;

    public FailureLoggingCallback(CommandCallback<C, R> delegate) {
        this(LoggerFactory.getLogger(FailureLoggingCallback.class), delegate);
    }

    public FailureLoggingCallback(Logger logger, CommandCallback<C, R> delegate) {
        this.logger = logger;
        this.delegate = delegate;
    }

    @Override
    public void onSuccess(CommandMessage<? extends C> commandMessage, R result) {
        this.delegate.onSuccess(commandMessage, result);
    }

    @Override
    public void onFailure(CommandMessage<? extends C> commandMessage, Throwable cause) {
        this.logger.warn("Command '{}' resulted in {}({})", new Object[]{commandMessage.getCommandName(), cause.getClass().getName(), cause.getMessage()});
        this.delegate.onFailure(commandMessage, cause);
    }
}

