/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.MonitorAwareCallback;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.Registration;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCommandBus
implements CommandBus {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCommandBus.class);
    private final ConcurrentMap<String, MessageHandler<? super CommandMessage<?>>> subscriptions = new ConcurrentHashMap();
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final MessageMonitor<? super CommandMessage<?>> messageMonitor;
    private final TransactionManager transactionManager;
    private RollbackConfiguration rollbackConfiguration = RollbackConfigurationType.UNCHECKED_EXCEPTIONS;

    public SimpleCommandBus() {
        this(NoTransactionManager.INSTANCE, NoOpMessageMonitor.INSTANCE);
    }

    public SimpleCommandBus(TransactionManager transactionManager, MessageMonitor<? super CommandMessage<?>> messageMonitor) {
        this.transactionManager = transactionManager;
        this.messageMonitor = messageMonitor;
    }

    @Override
    public <C, R> void dispatch(CommandMessage<C> command, CommandCallback<? super C, R> callback) {
        this.doDispatch(this.intercept(command), callback);
    }

    protected <C> CommandMessage<C> intercept(CommandMessage<C> command) {
        CommandMessage<C> commandToDispatch = command;
        for (MessageDispatchInterceptor<CommandMessage<?>> interceptor : this.dispatchInterceptors) {
            commandToDispatch = interceptor.handle(commandToDispatch);
        }
        return commandToDispatch;
    }

    protected <C, R> void doDispatch(CommandMessage<C> command, CommandCallback<? super C, R> callback) {
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(command);
        MessageHandler<? super CommandMessage<?>> handler = this.findCommandHandlerFor(command).orElseThrow(() -> {
            NoHandlerForCommandException exception = new NoHandlerForCommandException(String.format("No handler was subscribed to command [%s]", command.getCommandName()));
            monitorCallback.reportFailure(exception);
            return exception;
        });
        this.handle(command, handler, new MonitorAwareCallback<C, R>(callback, monitorCallback));
    }

    private Optional<MessageHandler<? super CommandMessage<?>>> findCommandHandlerFor(CommandMessage<?> command) {
        return Optional.ofNullable(this.subscriptions.get(command.getCommandName()));
    }

    protected <C, R> void handle(CommandMessage<C> command, MessageHandler<? super CommandMessage<?>> handler, CommandCallback<? super C, R> callback) {
        if (logger.isDebugEnabled()) {
            logger.debug("Handling command [{}]", (Object)command.getCommandName());
        }
        try {
            DefaultUnitOfWork<CommandMessage<C>> unitOfWork = DefaultUnitOfWork.startAndGet(command);
            unitOfWork.attachTransaction(this.transactionManager);
            DefaultInterceptorChain chain = new DefaultInterceptorChain(unitOfWork, this.handlerInterceptors, handler);
            Object result = unitOfWork.executeWithResult(chain::proceed, this.rollbackConfiguration);
            callback.onSuccess(command, result);
        }
        catch (Exception e) {
            callback.onFailure(command, e);
        }
    }

    @Override
    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> handler) {
        this.subscriptions.put(commandName, handler);
        return () -> this.subscriptions.remove(commandName, handler);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        this.handlerInterceptors.add(handlerInterceptor);
        return () -> this.handlerInterceptors.remove(handlerInterceptor);
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    public void setRollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
        this.rollbackConfiguration = rollbackConfiguration;
    }
}

