/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.monitoring.MessageMonitor;

public class MonitorAwareCallback<C, R>
implements CommandCallback<C, R> {
    private final CommandCallback<C, R> delegate;
    private final MessageMonitor.MonitorCallback messageMonitorCallback;

    public MonitorAwareCallback(CommandCallback<C, R> delegate, MessageMonitor.MonitorCallback messageMonitorCallback) {
        this.delegate = delegate;
        this.messageMonitorCallback = messageMonitorCallback;
    }

    @Override
    public void onSuccess(CommandMessage<? extends C> commandMessage, R result) {
        this.messageMonitorCallback.reportSuccess();
        if (this.delegate != null) {
            this.delegate.onSuccess(commandMessage, result);
        }
    }

    @Override
    public void onFailure(CommandMessage<? extends C> commandMessage, Throwable cause) {
        this.messageMonitorCallback.reportFailure(cause);
        if (this.delegate != null) {
            this.delegate.onFailure(commandMessage, cause);
        }
    }
}

