/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;

public class AsynchronousCommandBus
extends SimpleCommandBus {
    private final Executor executor;

    public AsynchronousCommandBus() {
        this(Executors.newCachedThreadPool(new AxonThreadFactory(AsynchronousCommandBus.class.getSimpleName())));
    }

    public AsynchronousCommandBus(Executor executor) {
        this(executor, NoTransactionManager.INSTANCE, NoOpMessageMonitor.INSTANCE);
    }

    public AsynchronousCommandBus(Executor executor, TransactionManager transactionManager, MessageMonitor<? super CommandMessage<?>> messageMonitor) {
        super(transactionManager, messageMonitor);
        Assert.notNull(executor, () -> "executor may not be null");
        this.executor = executor;
    }

    @Override
    protected <C, R> void handle(CommandMessage<C> command, MessageHandler<? super CommandMessage<?>> handler, CommandCallback<? super C, R> callback) {
        this.executor.execute(() -> super.handle(command, handler, callback));
    }

    public void shutdown() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
            try {
                ((ExecutorService)this.executor).awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

