/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.SupportedCommandNamesAware;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.common.Assert;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotationCommandHandlerAdapter
implements MessageHandler<CommandMessage<?>>,
SupportedCommandNamesAware {
    private final Object target;
    private final AggregateModel<Object> modelInspector;

    public AnnotationCommandHandlerAdapter(Object annotatedCommandHandler) {
        this(annotatedCommandHandler, ClasspathParameterResolverFactory.forClass(annotatedCommandHandler.getClass()));
    }

    public AnnotationCommandHandlerAdapter(Object annotatedCommandHandler, ParameterResolverFactory parameterResolverFactory) {
        this(annotatedCommandHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedCommandHandler.getClass()));
    }

    public AnnotationCommandHandlerAdapter(Object annotatedCommandHandler, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        Assert.notNull(annotatedCommandHandler, () -> "annotatedCommandHandler may not be null");
        this.modelInspector = AnnotatedAggregateMetaModelFactory.inspectAggregate(annotatedCommandHandler.getClass(), parameterResolverFactory, handlerDefinition);
        this.target = annotatedCommandHandler;
    }

    public Registration subscribe(CommandBus commandBus) {
        Collection subscriptions = this.supportedCommandNames().stream().map(supportedCommand -> commandBus.subscribe((String)supportedCommand, this)).collect(Collectors.toCollection(ArrayDeque::new));
        return () -> subscriptions.stream().map(Registration::cancel).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public Object handle(CommandMessage<?> command) throws Exception {
        return this.modelInspector.commandHandler(command.getCommandName()).handle(command, this.target);
    }

    @Override
    public Set<String> supportedCommandNames() {
        return this.modelInspector.commandHandlers().keySet();
    }
}

