/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.axonframework.commandhandling.AnnotationCommandTargetResolver;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.SupportedCommandNamesAware;
import org.axonframework.commandhandling.VersionedAggregateIdentifier;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.commandhandling.model.inspection.CommandMessageHandlingMember;
import org.axonframework.common.Assert;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AggregateAnnotationCommandHandler<T>
implements MessageHandler<CommandMessage<?>>,
SupportedCommandNamesAware {
    private final Repository<T> repository;
    private final CommandTargetResolver commandTargetResolver;
    private final Map<String, MessageHandler<CommandMessage<?>>> handlers;

    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository) {
        this(aggregateType, repository, new AnnotationCommandTargetResolver());
    }

    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository, CommandTargetResolver commandTargetResolver) {
        this(aggregateType, repository, commandTargetResolver, ClasspathParameterResolverFactory.forClass(aggregateType));
    }

    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository, CommandTargetResolver commandTargetResolver, ParameterResolverFactory parameterResolverFactory) {
        this(repository, commandTargetResolver, AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateType, parameterResolverFactory));
    }

    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository, CommandTargetResolver commandTargetResolver, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this(repository, commandTargetResolver, AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateType, parameterResolverFactory, handlerDefinition));
    }

    public AggregateAnnotationCommandHandler(Repository<T> repository, CommandTargetResolver commandTargetResolver, AggregateModel<T> aggregateModel) {
        Assert.notNull(aggregateModel, () -> "aggregateModel may not be null");
        Assert.notNull(repository, () -> "repository may not be null");
        Assert.notNull(commandTargetResolver, () -> "commandTargetResolver may not be null");
        this.repository = repository;
        this.commandTargetResolver = commandTargetResolver;
        this.handlers = this.initializeHandlers(aggregateModel);
    }

    public Registration subscribe(CommandBus commandBus) {
        ArrayList<Registration> subscriptions = new ArrayList<Registration>();
        for (String supportedCommand : this.supportedCommandNames()) {
            Registration subscription = commandBus.subscribe(supportedCommand, this);
            if (subscription == null) continue;
            subscriptions.add(subscription);
        }
        return () -> {
            subscriptions.forEach(Registration::cancel);
            return true;
        };
    }

    private Map<String, MessageHandler<CommandMessage<?>>> initializeHandlers(AggregateModel<T> aggregateModel) {
        HashMap handlersFound = new HashMap();
        AggregateCommandHandler aggregateCommandHandler = new AggregateCommandHandler();
        aggregateModel.commandHandlers().forEach((k, v) -> {
            if (v.unwrap(CommandMessageHandlingMember.class).map(CommandMessageHandlingMember::isFactoryHandler).orElse(false).booleanValue()) {
                handlersFound.put((String)k, new AggregateConstructorCommandHandler((MessageHandlingMember<?>)v));
            } else {
                handlersFound.put((String)k, aggregateCommandHandler);
            }
        });
        return handlersFound;
    }

    @Override
    public Object handle(CommandMessage<?> commandMessage) throws Exception {
        return this.handlers.get(commandMessage.getCommandName()).handle(commandMessage);
    }

    protected Object resolveReturnValue(CommandMessage<?> command, Aggregate<T> createdAggregate) {
        return createdAggregate.identifier();
    }

    @Override
    public Set<String> supportedCommandNames() {
        return this.handlers.keySet();
    }

    private class AggregateCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private AggregateCommandHandler() {
        }

        @Override
        public Object handle(CommandMessage<?> command) throws Exception {
            VersionedAggregateIdentifier iv = AggregateAnnotationCommandHandler.this.commandTargetResolver.resolveTarget(command);
            return AggregateAnnotationCommandHandler.this.repository.load(iv.getIdentifier(), iv.getVersion()).handle(command);
        }
    }

    private class AggregateConstructorCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<?> handler;

        public AggregateConstructorCommandHandler(MessageHandlingMember<?> handler) {
            this.handler = handler;
        }

        @Override
        public Object handle(CommandMessage<?> command) throws Exception {
            Aggregate<Object> aggregate = AggregateAnnotationCommandHandler.this.repository.newInstance(() -> this.handler.handle(command, null));
            return AggregateAnnotationCommandHandler.this.resolveReturnValue(command, aggregate);
        }
    }
}

