/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;

public class PathNode {
    private static final Pattern NODE = Pattern.compile("^([^\\[]*)(\\[(.+)\\])?$");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern LIST_CRITERIA_SYNTAX = Pattern.compile("^([^=]+)=(.+)$");
    public static final PathNode NULL = new PathNode("", Collections.emptyMap());
    private final String key;
    private final Map<String, String> criteria;

    public static List<String> split(String path) {
        ArrayList parts = _Lists.newArrayList();
        String curr = null;
        List chunks = _Strings.splitThenStream((String)path, (String)".").collect(Collectors.toList());
        for (String part : chunks) {
            if (curr != null) {
                if (part.contains("]")) {
                    curr = curr + "." + part;
                    parts.add(curr);
                    curr = null;
                    continue;
                }
                curr = curr + "." + part;
                continue;
            }
            if (!part.contains("[")) {
                parts.add(part);
                continue;
            }
            if (part.contains("]")) {
                parts.add(part);
                continue;
            }
            curr = part;
        }
        return parts;
    }

    public static PathNode parse(String path) {
        Matcher nodeMatcher = NODE.matcher(path);
        if (!nodeMatcher.matches()) {
            return null;
        }
        int groupCount = nodeMatcher.groupCount();
        if (groupCount < 1) {
            return null;
        }
        String key = nodeMatcher.group(1);
        HashMap criteria = _Maps.newHashMap();
        String criteriaStr = nodeMatcher.group(3);
        if (criteriaStr != null) {
            _Strings.splitThenStream((CharSequence)criteriaStr, (Pattern)WHITESPACE).forEach(criterium -> {
                Matcher keyValueMatcher = LIST_CRITERIA_SYNTAX.matcher((CharSequence)criterium);
                if (keyValueMatcher.matches()) {
                    criteria.put(keyValueMatcher.group(1), keyValueMatcher.group(2));
                } else {
                    criteria.put(criterium, null);
                }
            });
        }
        return new PathNode(key, criteria);
    }

    private PathNode(String key, Map<String, String> criteria) {
        this.key = key;
        this.criteria = Collections.unmodifiableMap(criteria);
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getCriteria() {
        return this.criteria;
    }

    public boolean hasCriteria() {
        return !this.getCriteria().isEmpty();
    }

    public boolean matches(JsonRepresentation repr) {
        if (!repr.isMap()) {
            return false;
        }
        for (Map.Entry<String, String> criterium : this.getCriteria().entrySet()) {
            String requiredValue = criterium.getValue();
            if (requiredValue != null) {
                String actualValue = repr.getString(criterium.getKey());
                if (actualValue == null) {
                    return false;
                }
                int actualValueSemiIndex = actualValue.indexOf(";");
                int requiredValueSemiIndex = requiredValue.indexOf(";");
                if (actualValueSemiIndex != -1 && requiredValueSemiIndex == -1) {
                    actualValue = actualValue.substring(0, actualValueSemiIndex);
                }
                if (actualValueSemiIndex == -1 && requiredValueSemiIndex != -1) {
                    requiredValue = requiredValue.substring(0, requiredValueSemiIndex);
                }
                if (Objects.equals(requiredValue, actualValue)) continue;
                return false;
            }
            return repr.getRepresentation(criterium.getKey(), new Object[0]) != null;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathNode other = (PathNode)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return this.key + (this.criteria.isEmpty() ? "" : this.criteria);
    }
}

