/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;

public abstract class DomainRepresentation
extends JsonRepresentation
implements JsonRepresentation.HasLinkToSelf,
JsonRepresentation.HasLinks,
JsonRepresentation.HasExtensions {
    public DomainRepresentation(JsonNode jsonNode) {
        super(jsonNode);
    }

    @Override
    public LinkRepresentation getSelf() {
        return this.getLinkWithRel(Rel.SELF);
    }

    @Override
    public JsonRepresentation getLinks() {
        return this.getArray("links").ensureArray();
    }

    public LinkRepresentation getLinkWithRel(Rel rel) {
        return this.getLinks().streamArrayElements(LinkRepresentation.class).filter(linkRepr -> rel.matches(linkRepr.getRel())).findFirst().orElse(null);
    }

    public LinkRepresentation getLinkWithRel(String rel) {
        return this.getLink(String.format("links[rel=%s]", rel));
    }

    @Override
    public JsonRepresentation getExtensions() {
        return this.getMap("extensions");
    }
}

