/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/objects")
public interface DomainObjectResource {
    @POST
    @Path(value="/{domainType}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response persist(@PathParam(value="domainType") String var1, InputStream var2);

    @GET
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response object(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @PUT
    @Path(value="/{domainType}/{instanceId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response object(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, InputStream var3);

    @DELETE
    @Path(value="/{domainType}/{instanceId}")
    public Response deleteMethodNotSupported(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @POST
    @Path(value="/{domainType}/{instanceId}")
    public Response postMethodNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @GET
    @Path(value="/{domainType}/{instanceId}/image")
    @Consumes(value={"*/*"})
    @Produces(value={"image/png"})
    public Response image(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @GET
    @Path(value="/{domainType}/{instanceId}/object-layout")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-layout-bs3", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-layout-bs3"})
    public Response layout(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2);

    @GET
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response propertyDetails(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3);

    @PUT
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response modifyProperty(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3, InputStream var4);

    @DELETE
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response clearProperty(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3);

    @POST
    @Path(value="/{domainType}/{instanceId}/properties/{propertyId}")
    public Response postPropertyNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="propertyId") String var3);

    @GET
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response accessCollection(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="collectionId") String var3);

    @PUT
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToSet(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="collectionId") String var3, InputStream var4);

    @POST
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response addToList(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="collectionId") String var3, InputStream var4);

    @DELETE
    @Path(value="/{domainType}/{instanceId}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response removeFromCollection(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="collectionId") String var3);

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/object-action", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response actionPrompt(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @DELETE
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response deleteActionPromptNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response putActionPromptNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}")
    public Response postActionPromptNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);

    @GET
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionQueryOnly(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3, @QueryParam(value="x-isis-querystring") String var4);

    @PUT
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeActionIdempotent(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3, InputStream var4);

    @POST
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/error"})
    public Response invokeAction(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3, InputStream var4);

    @DELETE
    @Path(value="/{domainType}/{instanceId}/actions/{actionId}/invoke")
    public Response deleteInvokeActionNotAllowed(@PathParam(value="domainType") String var1, @PathParam(value="instanceId") String var2, @PathParam(value="actionId") String var3);
}

