/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulClient;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;

public class RepresentationWalker {
    private final RestfulClient restfulClient;
    private final List<Step> steps = new LinkedList<Step>();

    public RepresentationWalker(RestfulClient restfulClient, Response response) {
        this.restfulClient = restfulClient;
        RestfulResponse<JsonRepresentation> jsonResp = RestfulResponse.of(response);
        this.addStep(null, null, null, jsonResp, null, null);
    }

    private Step addStep(String key, LinkRepresentation link, JsonRepresentation body, RestfulResponse<JsonRepresentation> jsonResp, String error, Exception ex) {
        Step step = new Step(key, link, body, jsonResp, error, ex);
        this.steps.add(0, step);
        if (error != null && jsonResp.getStatus().getFamily() != Response.Status.Family.SUCCESSFUL) {
            step.error = "response status code: " + jsonResp.getStatus();
        }
        return step;
    }

    public void walk(String path) {
        this.walk(path, null);
    }

    public void walk(String path, JsonRepresentation invokeBody) {
        RestfulResponse<JsonRepresentation> response;
        LinkRepresentation link;
        JsonRepresentation entity;
        Step previousStep = this.currentStep();
        if (previousStep.error != null) {
            return;
        }
        RestfulResponse jsonResponse = previousStep.response;
        try {
            entity = (JsonRepresentation)jsonResponse.getEntity();
        }
        catch (Exception e) {
            this.addStep(path, null, null, null, "exception: " + e.getMessage(), e);
            return;
        }
        try {
            link = entity.getLink(path);
        }
        catch (Exception e) {
            this.addStep(path, null, null, null, "exception: " + e.getMessage(), e);
            return;
        }
        if (link == null) {
            this.addStep(path, null, null, null, "no such link '" + path + "'", null);
            return;
        }
        try {
            response = invokeBody != null ? this.restfulClient.follow(link, invokeBody) : this.restfulClient.follow(link);
        }
        catch (Exception e) {
            this.addStep(path, link, null, null, "failed to follow link: " + e.getMessage(), e);
            return;
        }
        this.addStep(path, link, null, response, null, null);
    }

    public JsonRepresentation getEntity() throws JsonParseException, JsonMappingException, IOException {
        Step currentStep = this.currentStep();
        if (currentStep.response == null || currentStep.error != null) {
            return null;
        }
        return (JsonRepresentation)currentStep.response.getEntity();
    }

    public RestfulResponse<?> getResponse() {
        Step currentStep = this.currentStep();
        return currentStep != null ? currentStep.response : null;
    }

    public String getError() {
        Step currentStep = this.currentStep();
        return currentStep != null ? currentStep.error : null;
    }

    public Exception getException() {
        Step currentStep = this.currentStep();
        return currentStep != null ? currentStep.exception : null;
    }

    private Step currentStep() {
        return this.steps.get(0);
    }

    static class Step {
        private final String key;
        private final LinkRepresentation link;
        private final JsonRepresentation body;
        private final RestfulResponse<? extends JsonRepresentation> response;
        private String error;
        private final Exception exception;

        public Step(String key, LinkRepresentation link, JsonRepresentation body, RestfulResponse<? extends JsonRepresentation> response, String error, Exception exception) {
            this.key = key;
            this.link = link;
            this.body = body;
            this.response = response;
            this.error = error;
            this.exception = exception;
        }

        public String toString() {
            return "Step [key=" + this.key + ", link=" + (this.link != null ? this.link.getHref() : "(null)") + ", error=" + this.error + "]";
        }
    }
}

