/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.client;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.isis.viewer.legacy.ClientExecutor;
import org.apache.isis.viewer.legacy.ClientRequest;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulRequest;
import org.apache.isis.viewer.restfulobjects.applib.client.UriBuilderPlugin;
import org.apache.isis.viewer.restfulobjects.applib.util.UrlEncodingUtils;

public class ClientRequestConfigurer {
    private final ClientRequest clientRequest;
    private final UriBuilder uriBuilder;

    public static ClientRequestConfigurer create(ClientExecutor executor, String uriTemplate) {
        UriBuilder uriBuilder = UriBuilderPlugin.get().uriTemplate(uriTemplate);
        ClientRequest clientRequest = executor.createRequest(uriBuilder);
        return new ClientRequestConfigurer(clientRequest, uriBuilder);
    }

    ClientRequestConfigurer(ClientRequest clientRequest, UriBuilder uriBuilder) {
        this.clientRequest = clientRequest;
        this.uriBuilder = uriBuilder;
    }

    public ClientRequestConfigurer accept(MediaType mediaType) {
        this.clientRequest.accept(mediaType);
        return this;
    }

    public ClientRequestConfigurer header(String name, String value) {
        this.clientRequest.header(name, value);
        return this;
    }

    public ClientRequestConfigurer setHttpMethod(RestfulHttpMethod httpMethod) {
        this.clientRequest.setHttpMethod(httpMethod.getJavaxRsMethod());
        return this;
    }

    public ClientRequestConfigurer configureArgs(Map<RestfulRequest.RequestParameter<?>, Object> args) {
        if (this.clientRequest.getHttpMethod() == null) {
            throw new IllegalStateException("Must set up http method first");
        }
        JsonRepresentation argsAsMap = JsonRepresentation.newMap(new String[0]);
        for (RestfulRequest.RequestParameter<?> requestParam : args.keySet()) {
            this.put(args, requestParam, argsAsMap);
        }
        this.getHttpMethod().setUpArgs(this, argsAsMap);
        return this;
    }

    private <P> void put(Map<RestfulRequest.RequestParameter<?>, Object> args, RestfulRequest.RequestParameter<P> requestParam, JsonRepresentation argsAsMap) {
        Object value = args.get(requestParam);
        String valueStr = requestParam.getParser().asString(value);
        argsAsMap.mapPut(requestParam.getName(), valueStr);
    }

    public ClientRequestConfigurer configureArgs(JsonRepresentation requestArgs) {
        if (this.clientRequest.getHttpMethod() == null) {
            throw new IllegalStateException("Must set up http method first");
        }
        this.getHttpMethod().setUpArgs(this, requestArgs);
        return this;
    }

    public ClientRequestConfigurer body(JsonRepresentation requestArgs) {
        this.clientRequest.jsonPayload(requestArgs.toString());
        return this;
    }

    public ClientRequestConfigurer queryString(JsonRepresentation requestArgs) {
        if (requestArgs.size() == 0) {
            return this;
        }
        String queryString = UrlEncodingUtils.urlEncode(requestArgs.toString());
        this.uriBuilder.replaceQuery(queryString);
        return this;
    }

    public ClientRequestConfigurer queryArgs(JsonRepresentation requestArgs) {
        requestArgs.streamMapEntries().forEach(entry -> {
            String param = (String)entry.getKey();
            JsonRepresentation argRepr = (JsonRepresentation)entry.getValue();
            String arg = UrlEncodingUtils.urlEncode(argRepr.asArg());
            this.clientRequest.addQueryParameter(param, arg);
        });
        return this;
    }

    ClientRequest getClientRequest() {
        return this.clientRequest;
    }

    RestfulHttpMethod getHttpMethod() {
        String httpMethod = this.clientRequest.getHttpMethod();
        return RestfulHttpMethod.valueOf(httpMethod);
    }
}

