/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.legacy;

import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.isis.viewer.legacy.ClientRequest;

public interface ClientExecutor {
    public ClientRequest createRequest(UriBuilder var1);

    public WebTarget webTarget(URI var1);

    public static ClientExecutor of(final Client client) {
        return new ClientExecutor(){

            @Override
            public ClientRequest createRequest(final UriBuilder uriBuilder) {
                return new ClientRequest(){
                    final WebTarget target;
                    final List<MediaType> accept;
                    final List<Map.Entry<String, String>> header;
                    private Entity<String> payload;
                    private String method;
                    {
                        this.target = client.target(uriBuilder);
                        this.accept = new ArrayList<MediaType>();
                        this.header = new ArrayList<Map.Entry<String, String>>();
                        this.method = "get";
                    }

                    @Override
                    public String getHttpMethod() {
                        return this.method;
                    }

                    @Override
                    public void setHttpMethod(String method) {
                        this.method = method;
                    }

                    @Override
                    public void accept(MediaType mediaType) {
                        this.accept.add(mediaType);
                    }

                    @Override
                    public void header(String headerName, String value) {
                        this.header.add(new AbstractMap.SimpleEntry<String, String>(headerName, value));
                    }

                    @Override
                    public void addQueryParameter(String param, String arg) {
                        this.target.queryParam(param, new Object[]{arg});
                    }

                    @Override
                    public void jsonPayload(String jsonString) {
                        this.payload = Entity.json((Object)jsonString);
                    }

                    @Override
                    public Response execute() {
                        Invocation.Builder builder = this.target.request();
                        this.accept.stream().forEach(xva$0 -> builder.accept(new MediaType[]{xva$0}));
                        this.header.stream().forEach(e -> builder.header((String)e.getKey(), e.getValue()));
                        Invocation invocation = this.payload == null ? builder.build(this.method) : builder.build(this.method, this.payload);
                        return invocation.invoke();
                    }
                };
            }

            @Override
            public WebTarget webTarget(URI baseUri) {
                return client.target(baseUri);
            }
        };
    }
}

