/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.query;

import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.specimpl.IntrospectionState;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.VisitorForClauseAbstract;

class VisitorForVariablesClause
extends VisitorForClauseAbstract {
    VisitorForVariablesClause(JdoQueryAnnotationFacetFactory facetFactory) {
        super(facetFactory, "VARIABLES");
    }

    @Override
    String deriveClause(String query) {
        return JdoQueryAnnotationFacetFactory.variables(query);
    }

    @Override
    void postInterpretJdoql(String classNameFromClause, ObjectSpecification objectSpec, String query, ValidationFailures validationFailures) {
        String className = objectSpec.getCorrespondingClass().getName();
        ObjectSpecification objectSpecification = this.getSpecificationLoader().loadSpecification(classNameFromClause, IntrospectionState.TYPE_INTROSPECTED);
        JdoPersistenceCapableFacet persistenceCapableFacet = objectSpecification.getFacet(JdoPersistenceCapableFacet.class);
        if (persistenceCapableFacet == null) {
            validationFailures.add("%s: error in JDOQL query, class name for '%s' clause is not annotated as @PersistenceCapable (JDOQL : %s)", className, this.clause, query);
            return;
        }
    }
}

