/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.actions.notcontributed.NotContributedFacet;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.help.HelpFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.object.navparent.NavigableParentFacet;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.facets.object.parented.ParentedCollectionFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.layout.DeweyOrderSet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.Hierarchical;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.postprocessor.PostProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.specloader.specimpl.IntrospectionState;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectAssociationAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationMixedIn;
import org.apache.isis.core.plugins.environment.DeploymentType;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectSpecificationAbstract
extends FacetHolderImpl
implements ObjectSpecification {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectSpecificationAbstract.class);
    protected final ServicesInjector servicesInjector;
    private PostProcessor postProcessor;
    private final DeploymentType deploymentType;
    private final SpecificationLoader specificationLoader;
    private final FacetProcessor facetProcessor;
    private final List<ObjectAssociation> associations = _Lists.newArrayList();
    private final List<ObjectAction> objectActions = _Lists.newArrayList();
    private final Map<ActionType, List<ObjectAction>> objectActionsByType = ObjectSpecificationAbstract.createObjectActionsByType();
    private final List<ObjectSpecification> interfaces = _Lists.newArrayList();
    private final SubclassList directSubclasses = new SubclassList();
    private SubclassList transitiveSubclasses;
    private final Class<?> correspondingClass;
    private final String fullName;
    private final String shortName;
    private final Identifier identifier;
    private final boolean isAbstract;
    protected ObjectSpecId specId;
    private ObjectSpecification superclassSpec;
    private TitleFacet titleFacet;
    private IconFacet iconFacet;
    private NavigableParentFacet navigableParentFacet;
    private CssClassFacet cssClassFacet;
    private IntrospectionState introspectionState = IntrospectionState.NOT_INTROSPECTED;
    private static ThreadLocal<Boolean> invalidatingCache = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private boolean contributeeAndMixedInAssociationsAdded;
    private boolean contributeeAndMixedInActionsAdded;

    private static Map<ActionType, List<ObjectAction>> createObjectActionsByType() {
        HashMap map = _Maps.newHashMap();
        for (ActionType type : ActionType.values()) {
            map.put(type, _Lists.newArrayList());
        }
        return map;
    }

    public ObjectSpecificationAbstract(Class<?> introspectedClass, String shortName, ServicesInjector servicesInjector, FacetProcessor facetProcessor, PostProcessor postProcessor) {
        this.correspondingClass = introspectedClass;
        this.fullName = introspectedClass.getName();
        this.shortName = shortName;
        this.isAbstract = ClassExtensions.isAbstract(introspectedClass);
        this.identifier = Identifier.classIdentifier(introspectedClass);
        this.servicesInjector = servicesInjector;
        this.facetProcessor = facetProcessor;
        this.specificationLoader = servicesInjector.getSpecificationLoader();
        this.deploymentType = _Context.getEnvironment().getDeploymentType();
        this.postProcessor = postProcessor;
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.OBJECT;
    }

    @Override
    public ObjectSpecId getSpecId() {
        if (this.specId == null) {
            ObjectSpecIdFacet facet = this.getFacet((Class)ObjectSpecIdFacet.class);
            if (facet == null) {
                throw new IllegalStateException("could not find an ObjectSpecIdFacet for " + this.getFullIdentifier());
            }
            this.specId = facet.value();
        }
        return this.specId;
    }

    @Override
    public Class<?> getCorrespondingClass() {
        return this.correspondingClass;
    }

    @Override
    public String getShortIdentifier() {
        return this.shortName;
    }

    @Override
    public String getFullIdentifier() {
        return this.fullName;
    }

    public void introspectUpTo(IntrospectionState upTo) {
        LOG.debug("introspectingUpTo: {}, {}", (Object)this.getFullIdentifier(), (Object)upTo);
        switch (this.introspectionState) {
            case NOT_INTROSPECTED: {
                if (this.introspectionState.compareTo(upTo) < 0) {
                    this.introspectionState = IntrospectionState.TYPE_BEING_INTROSPECTED;
                    this.introspectTypeHierarchy();
                    this.updateFromFacetValues();
                    this.introspectionState = IntrospectionState.TYPE_INTROSPECTED;
                }
                if (this.introspectionState.compareTo(upTo) >= 0) break;
                this.introspectionState = IntrospectionState.MEMBERS_BEING_INTROSPECTED;
                this.introspectMembers();
                this.introspectionState = IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED;
                break;
            }
            case TYPE_BEING_INTROSPECTED: {
                break;
            }
            case TYPE_INTROSPECTED: {
                if (this.introspectionState.compareTo(upTo) >= 0) break;
                this.introspectionState = IntrospectionState.MEMBERS_BEING_INTROSPECTED;
                this.introspectMembers();
                this.introspectionState = IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED;
                break;
            }
        }
    }

    protected abstract void introspectTypeHierarchy();

    protected abstract void introspectMembers();

    protected void loadSpecOfSuperclass(Class<?> superclass) {
        if (superclass == null) {
            return;
        }
        this.superclassSpec = this.getSpecificationLoader().loadSpecification(superclass);
        if (this.superclassSpec != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Superclass {}", (Object)superclass.getName());
            }
            this.updateAsSubclassTo(this.superclassSpec);
        }
    }

    protected void updateInterfaces(List<ObjectSpecification> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
    }

    private void updateAsSubclassTo(ObjectSpecification supertypeSpec) {
        if (!(supertypeSpec instanceof ObjectSpecificationAbstract)) {
            return;
        }
        ObjectSpecificationAbstract introspectableSpec = (ObjectSpecificationAbstract)supertypeSpec;
        introspectableSpec.updateSubclasses(this);
    }

    protected void updateAsSubclassTo(List<ObjectSpecification> supertypeSpecs) {
        for (ObjectSpecification supertypeSpec : supertypeSpecs) {
            this.updateAsSubclassTo(supertypeSpec);
        }
    }

    private void updateSubclasses(ObjectSpecification subclass) {
        this.directSubclasses.addSubclass(subclass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortAndUpdateAssociations(List<ObjectAssociation> associations) {
        List<ObjectAssociation> orderedAssociations = this.sortAssociations(associations);
        List<ObjectAssociation> list = this.associations;
        synchronized (list) {
            this.associations.clear();
            this.associations.addAll(orderedAssociations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortCacheAndUpdateActions(List<ObjectAction> objectActions) {
        List<ObjectAction> orderedActions = ObjectSpecificationAbstract.sortActions(objectActions);
        List<ObjectAction> list = this.objectActions;
        synchronized (list) {
            this.objectActions.clear();
            this.objectActions.addAll(orderedActions);
            for (ActionType type : ActionType.values()) {
                List<ObjectAction> objectActionForType = this.objectActionsByType.get((Object)type);
                objectActionForType.clear();
                objectActions.stream().filter(ObjectAction.Predicates.ofType(type)).forEach(objectActionForType::add);
            }
        }
    }

    private void updateFromFacetValues() {
        this.titleFacet = this.getFacet((Class)TitleFacet.class);
        this.iconFacet = this.getFacet((Class)IconFacet.class);
        this.navigableParentFacet = this.getFacet((Class)NavigableParentFacet.class);
        this.cssClassFacet = this.getFacet((Class)CssClassFacet.class);
    }

    protected void postProcess() {
        this.postProcessor.postProcess(this);
        this.updateFromFacetValues();
    }

    @Override
    public String getTitle(ManagedObject contextAdapterIfAny, ManagedObject targetAdapter) {
        String titleString;
        if (this.titleFacet != null && !_Strings.isEmpty((CharSequence)(titleString = this.titleFacet.title(contextAdapterIfAny, targetAdapter)))) {
            return titleString;
        }
        return (this.isService() ? "" : "Untitled ") + this.getSingularName();
    }

    @Override
    public String getIconName(ManagedObject reference) {
        return this.iconFacet == null ? null : this.iconFacet.iconName(reference);
    }

    @Override
    public Object getNavigableParent(Object object) {
        return this.navigableParentFacet == null ? null : this.navigableParentFacet.navigableParent(object);
    }

    @Override
    public String getCssClass(ManagedObject reference) {
        return this.cssClassFacet == null ? null : this.cssClassFacet.cssClass(reference);
    }

    @Override
    public boolean isOfType(ObjectSpecification specification) {
        if (specification.getSpecId().equals(this.getSpecId())) {
            return true;
        }
        for (ObjectSpecification interfaceSpec : this.interfaces()) {
            if (!interfaceSpec.isOfType(specification)) continue;
            return true;
        }
        ObjectSpecification superclassSpec = this.superclass();
        return superclassSpec != null && superclassSpec.isOfType(specification);
    }

    @Override
    public String getSingularName() {
        NamedFacet namedFacet = this.getFacet((Class)NamedFacet.class);
        return namedFacet != null ? namedFacet.value() : this.getFullIdentifier();
    }

    @Override
    public String getPluralName() {
        PluralFacet pluralFacet = this.getFacet((Class)PluralFacet.class);
        return (String)pluralFacet.value();
    }

    @Override
    public String getDescription() {
        DescribedAsFacet describedAsFacet = this.getFacet((Class)DescribedAsFacet.class);
        String describedAs = (String)describedAsFacet.value();
        return describedAs == null ? "" : describedAs;
    }

    @Override
    public String getHelp() {
        HelpFacet helpFacet = this.getFacet((Class)HelpFacet.class);
        return helpFacet == null ? null : (String)helpFacet.value();
    }

    public <Q extends Facet> Q getFacet(Class<Q> facetType) {
        Stream facets1 = _NullSafe.streamNullable(super.getFacet(facetType));
        Stream<Facet> facets2 = _NullSafe.stream(this.interfaces).filter(_NullSafe::isPresent).map(interfaceSpec -> interfaceSpec.getFacet(facetType));
        Stream<Facet> facets3 = _NullSafe.streamNullable((Object)this.superclass()).map(superSpec -> superSpec.getFacet(facetType));
        Stream<Facet> facetsCombined = Stream.concat(Stream.concat(facets1, facets2), facets3);
        NotANoopFacetFilter notANoopFacetFilter = new NotANoopFacetFilter();
        return (Q)facetsCombined.filter(notANoopFacetFilter).findFirst().orElse((Facet)notANoopFacetFilter.noopFacet);
    }

    @Override
    @Deprecated
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public ObjectTitleContext createTitleInteractionContext(AuthenticationSession session, InteractionInitiatedBy interactionMethod, ManagedObject targetObjectAdapter) {
        return new ObjectTitleContext(targetObjectAdapter, this.getIdentifier(), targetObjectAdapter.titleString(null), interactionMethod);
    }

    @Override
    public ObjectSpecification superclass() {
        return this.superclassSpec;
    }

    @Override
    public List<ObjectSpecification> interfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    @Override
    public List<ObjectSpecification> subclasses() {
        return this.subclasses(Hierarchical.Depth.DIRECT);
    }

    @Override
    public List<ObjectSpecification> subclasses(Hierarchical.Depth depth) {
        if (depth == Hierarchical.Depth.DIRECT) {
            return this.directSubclasses.toList();
        }
        if (this.transitiveSubclasses == null) {
            this.transitiveSubclasses = this.transitiveSubclasses();
        }
        return this.transitiveSubclasses.toList();
    }

    private synchronized SubclassList transitiveSubclasses() {
        SubclassList appendTo = new SubclassList();
        this.appendSubclasses(this, appendTo);
        this.transitiveSubclasses = appendTo;
        return this.transitiveSubclasses;
    }

    private void appendSubclasses(ObjectSpecification objectSpecification, SubclassList appendTo) {
        List<ObjectSpecification> directSubclasses = objectSpecification.subclasses(Hierarchical.Depth.DIRECT);
        for (ObjectSpecification subclass : directSubclasses) {
            appendTo.addSubclass(subclass);
            this.appendSubclasses(subclass, appendTo);
        }
    }

    @Override
    public boolean hasSubclasses() {
        return this.directSubclasses.hasSubclasses();
    }

    @Override
    public final boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public Stream<ObjectAssociation> streamAssociations(Contributed contributed) {
        this.introspectUpTo(IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        this.guardAgainstTooEarly_assoz(contributed);
        return _NullSafe.stream(this.associations).filter(ContributeeMember.Predicates.regularElse(contributed));
    }

    @Override
    public ObjectMember getMember(String memberId) {
        this.introspectUpTo(IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        ObjectAction objectAction = this.getObjectAction(memberId);
        if (objectAction != null) {
            return objectAction;
        }
        ObjectAssociation association = this.getAssociation(memberId);
        if (association != null) {
            return association;
        }
        return null;
    }

    @Override
    public ObjectAssociation getAssociation(String id) {
        this.introspectUpTo(IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        ObjectAssociation oa = this.getAssociationWithId(id);
        if (oa != null) {
            return oa;
        }
        if (_Context.isPrototyping()) {
            LOG.warn("Could not find association with id '{}'; invalidating cache automatically", (Object)id);
            if (!invalidatingCache.get().booleanValue()) {
                try {
                    invalidatingCache.set(true);
                    this.getSpecificationLoader().invalidateCache(this.getCorrespondingClass());
                }
                finally {
                    invalidatingCache.set(false);
                }
            } else {
                LOG.warn("... already invalidating cache earlier in stacktrace, so skipped this time");
            }
            oa = this.getAssociationWithId(id);
            if (oa != null) {
                return oa;
            }
        }
        throw new ObjectSpecificationException(String.format("No association called '%s' in '%s'", id, this.getSingularName()));
    }

    private ObjectAssociation getAssociationWithId(String id) {
        return this.streamAssociations(Contributed.INCLUDED).filter(objectAssociation -> objectAssociation.getId().equals(id)).findFirst().orElse(null);
    }

    @Override
    public Stream<ObjectAction> streamObjectActions(ActionType type, Contributed contributed) {
        this.introspectUpTo(IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        this.guardAgainstTooEarly_contrib(contributed);
        return _NullSafe.stream((Collection)this.objectActionsByType.get((Object)type)).filter(ContributeeMember.Predicates.regularElse(contributed));
    }

    private List<ObjectAssociation> sortAssociations(List<ObjectAssociation> associations) {
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet(associations);
        ArrayList orderedAssociations = _Lists.newArrayList();
        ObjectSpecificationAbstract.sortAssociations(orderSet, orderedAssociations);
        return orderedAssociations;
    }

    private static void sortAssociations(DeweyOrderSet orderSet, List<ObjectAssociation> associationsToAppendTo) {
        for (Object element : orderSet) {
            if (element instanceof OneToManyAssociation) {
                associationsToAppendTo.add((ObjectAssociation)element);
                continue;
            }
            if (element instanceof OneToOneAssociation) {
                associationsToAppendTo.add((ObjectAssociation)element);
                continue;
            }
            if (element instanceof DeweyOrderSet) {
                DeweyOrderSet childOrderSet = (DeweyOrderSet)element;
                ObjectSpecificationAbstract.sortAssociations(childOrderSet, associationsToAppendTo);
                continue;
            }
            throw new UnknownTypeException(element);
        }
    }

    private static List<ObjectAction> sortActions(List<ObjectAction> actions) {
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet(actions);
        ArrayList orderedActions = _Lists.newArrayList();
        ObjectSpecificationAbstract.sortActions(orderSet, orderedActions);
        return orderedActions;
    }

    private static void sortActions(DeweyOrderSet orderSet, List<ObjectAction> actionsToAppendTo) {
        for (Object element : orderSet) {
            if (element instanceof ObjectAction) {
                ObjectAction objectAction = (ObjectAction)element;
                actionsToAppendTo.add(objectAction);
                continue;
            }
            if (element instanceof DeweyOrderSet) {
                DeweyOrderSet set = (DeweyOrderSet)element;
                ArrayList actions = _Lists.newArrayList();
                ObjectSpecificationAbstract.sortActions(set, actions);
                actionsToAppendTo.addAll(actions);
                continue;
            }
            throw new UnknownTypeException(element);
        }
    }

    private Stream<Object> streamServicePojos() {
        return this.getServicesInjector().streamServices();
    }

    private List<ObjectAssociation> createContributeeAssociations() {
        if (this.isService() || this.isValue()) {
            return Collections.emptyList();
        }
        ArrayList contributeeAssociations = _Lists.newArrayList();
        this.streamServicePojos().forEach(servicePojo -> this.addContributeeAssociationsIfAny(servicePojo, contributeeAssociations));
        return contributeeAssociations;
    }

    private void addContributeeAssociationsIfAny(Object servicePojo, List<ObjectAssociation> contributeeAssociationsToAppendTo) {
        Class<?> serviceClass = servicePojo.getClass();
        ObjectSpecification specification = this.specificationLoader.loadSpecification(serviceClass, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        if (specification == this) {
            return;
        }
        List<ObjectAssociation> contributeeAssociations = this.createContributeeAssociations(servicePojo);
        contributeeAssociationsToAppendTo.addAll(contributeeAssociations);
    }

    private boolean canAdd(ObjectAction serviceAction) {
        if (this.isAlwaysHidden(serviceAction)) {
            return false;
        }
        NotContributedFacet notContributed = serviceAction.getFacet(NotContributedFacet.class);
        if (notContributed != null && notContributed.toAssociations()) {
            return false;
        }
        if (!serviceAction.hasReturn()) {
            return false;
        }
        if (serviceAction.getParameterCount() != 1 || this.contributeeParameterMatchOf(serviceAction) == -1) {
            return false;
        }
        if (!(serviceAction instanceof ObjectActionDefault)) {
            return false;
        }
        return serviceAction.getSemantics().isSafeInNature();
    }

    private List<ObjectAssociation> createContributeeAssociations(Object servicePojo) {
        Class<?> serviceClass = servicePojo.getClass();
        ObjectSpecification specification = this.specificationLoader.loadSpecification(serviceClass, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        Stream<ObjectAction> serviceActions = specification.streamObjectActions(ActionType.USER, Contributed.INCLUDED);
        return serviceActions.filter(this::canAdd).map(serviceAction -> (ObjectActionDefault)serviceAction).map(this.createContributeeAssociationFunctor(servicePojo, this)).collect(Collectors.toList());
    }

    private Function<ObjectActionDefault, ObjectAssociation> createContributeeAssociationFunctor(final Object servicePojo, final ObjectSpecification contributeeType) {
        return new Function<ObjectActionDefault, ObjectAssociation>(){

            @Override
            public ObjectAssociation apply(ObjectActionDefault input) {
                ObjectSpecification returnType = input.getReturnType();
                ObjectAssociationAbstract association = this.createObjectAssociation(input, returnType);
                ObjectSpecificationAbstract.this.facetProcessor.processMemberOrder(association);
                return association;
            }

            private ObjectAssociationAbstract createObjectAssociation(ObjectActionDefault input, ObjectSpecification returnType) {
                if (returnType.isNotCollection()) {
                    return new OneToOneAssociationContributee(servicePojo, input, contributeeType, ObjectSpecificationAbstract.this.servicesInjector);
                }
                return new OneToManyAssociationContributee(servicePojo, input, contributeeType, ObjectSpecificationAbstract.this.servicesInjector);
            }
        };
    }

    private List<ObjectAssociation> createMixedInAssociations() {
        if (this.isService() || this.isValue()) {
            return Collections.emptyList();
        }
        Set mixinTypes = AppManifest.Registry.instance().getMixinTypes();
        if (mixinTypes == null) {
            return Collections.emptyList();
        }
        ArrayList mixedInAssociations = _Lists.newArrayList();
        for (Class mixinType : mixinTypes) {
            this.addMixedInAssociationsIfAny(mixinType, mixedInAssociations);
        }
        return mixedInAssociations;
    }

    private void addMixedInAssociationsIfAny(Class<?> mixinType, List<ObjectAssociation> toAppendTo) {
        ObjectSpecification specification = this.getSpecificationLoader().loadSpecification(mixinType, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        if (specification == this) {
            return;
        }
        MixinFacet mixinFacet = specification.getFacet(MixinFacet.class);
        if (mixinFacet == null) {
            return;
        }
        if (!mixinFacet.isMixinFor(this.getCorrespondingClass())) {
            return;
        }
        Stream<ObjectActionDefault> mixinActions = this.objectActionsOf(specification);
        mixinActions.filter(input -> {
            NotContributedFacet notContributedFacet = input.getFacet(NotContributedFacet.class);
            if (notContributedFacet == null || !notContributedFacet.toActions()) {
                return false;
            }
            if (input.getParameterCount() != 0) {
                return false;
            }
            return input.getSemantics().isSafeInNature();
        }).map(this.createMixedInAssociationFunctor(this, mixinType, (String)mixinFacet.value())).forEach(toAppendTo::add);
    }

    private Stream<ObjectActionDefault> objectActionsOf(ObjectSpecification specification) {
        return specification.streamObjectActions(ActionType.ALL, Contributed.INCLUDED).map(a -> (ObjectActionDefault)a);
    }

    private Function<ObjectActionDefault, ObjectAssociation> createMixedInAssociationFunctor(final ObjectSpecification mixedInType, final Class<?> mixinType, final String mixinMethodName) {
        return new Function<ObjectActionDefault, ObjectAssociation>(){

            @Override
            public ObjectAssociation apply(ObjectActionDefault mixinAction) {
                ObjectAssociationAbstract association = this.createObjectAssociation(mixinAction);
                ObjectSpecificationAbstract.this.facetProcessor.processMemberOrder(association);
                return association;
            }

            ObjectAssociationAbstract createObjectAssociation(ObjectActionDefault mixinAction) {
                ObjectSpecification returnType = mixinAction.getReturnType();
                if (returnType.isNotCollection()) {
                    return new OneToOneAssociationMixedIn(mixinAction, mixedInType, mixinType, mixinMethodName, ObjectSpecificationAbstract.this.servicesInjector);
                }
                return new OneToManyAssociationMixedIn(mixinAction, mixedInType, mixinType, mixinMethodName, ObjectSpecificationAbstract.this.servicesInjector);
            }
        };
    }

    private List<ObjectAction> createContributeeActions() {
        if (this.isService() || this.isValue()) {
            return Collections.emptyList();
        }
        ArrayList contributeeActions = _Lists.newArrayList();
        this.streamServicePojos().forEach(servicePojo -> this.addContributeeActionsIfAny(servicePojo, contributeeActions));
        return contributeeActions;
    }

    private boolean canAddContributee(ObjectAction serviceAction) {
        if (this.isAlwaysHidden(serviceAction)) {
            return false;
        }
        NotContributedFacet notContributed = serviceAction.getFacet(NotContributedFacet.class);
        if (notContributed != null && notContributed.toActions()) {
            return false;
        }
        return serviceAction instanceof ObjectActionDefault;
    }

    private void addContributeeActionsIfAny(Object servicePojo, List<ObjectAction> contributeeActionsToAppendTo) {
        LOG.debug("{} : addContributeeActionsIfAny(...); servicePojo class is: {}", (Object)this.getFullIdentifier(), (Object)servicePojo.getClass().getName());
        Class<?> serviceType = servicePojo.getClass();
        ObjectSpecification specification = this.getSpecificationLoader().loadSpecification(serviceType, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        if (specification == this) {
            return;
        }
        Stream<ObjectAction> serviceActions = specification.streamObjectActions(ActionType.ALL, Contributed.INCLUDED);
        serviceActions.filter(this::canAddContributee).map(serviceAction -> (ObjectActionDefault)serviceAction).forEach(contributedAction -> {
            int contributeeParam = this.contributeeParameterMatchOf((ObjectAction)contributedAction);
            if (contributeeParam == -1) {
                return;
            }
            ObjectActionContributee contributeeAction = new ObjectActionContributee(servicePojo, (ObjectActionDefault)contributedAction, contributeeParam, this, this.servicesInjector);
            this.facetProcessor.processMemberOrder(contributeeAction);
            contributeeActionsToAppendTo.add(contributeeAction);
        });
    }

    private boolean isAlwaysHidden(FacetHolder holder) {
        HiddenFacet hiddenFacet = holder.getFacet(HiddenFacet.class);
        return hiddenFacet != null && hiddenFacet.where() == Where.ANYWHERE;
    }

    private int contributeeParameterMatchOf(ObjectAction serviceAction) {
        List<ObjectActionParameter> params = serviceAction.getParameters();
        for (ObjectActionParameter param : params) {
            if (!this.isOfType(param.getSpecification())) continue;
            return param.getNumber();
        }
        return -1;
    }

    private List<ObjectAction> createMixedInActions() {
        if (this.isService() || this.isValue()) {
            return Collections.emptyList();
        }
        Set mixinTypes = AppManifest.Registry.instance().getMixinTypes();
        if (mixinTypes == null) {
            return Collections.emptyList();
        }
        ArrayList mixedInActions = _Lists.newArrayList();
        for (Class mixinType : mixinTypes) {
            this.addMixedInActionsIfAny(mixinType, mixedInActions);
        }
        return mixedInActions;
    }

    private boolean canAddMixin(ObjectAction mixinTypeAction) {
        if (this.isAlwaysHidden(mixinTypeAction)) {
            return false;
        }
        if (!(mixinTypeAction instanceof ObjectActionDefault)) {
            return false;
        }
        ObjectActionDefault mixinAction = (ObjectActionDefault)mixinTypeAction;
        NotContributedFacet notContributedFacet = mixinAction.getFacet(NotContributedFacet.class);
        return notContributedFacet == null || !notContributedFacet.toActions();
    }

    private void addMixedInActionsIfAny(Class<?> mixinType, List<ObjectAction> mixedInActionsToAppendTo) {
        ObjectSpecification mixinSpec = this.getSpecificationLoader().loadSpecification(mixinType, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        if (mixinSpec == this) {
            return;
        }
        MixinFacet mixinFacet = mixinSpec.getFacet(MixinFacet.class);
        if (mixinFacet == null) {
            return;
        }
        if (!mixinFacet.isMixinFor(this.getCorrespondingClass())) {
            return;
        }
        Stream<ObjectAction> mixinActions = mixinSpec.streamObjectActions(ActionType.ALL, Contributed.INCLUDED);
        mixinActions.filter(this::canAddMixin).forEach(mixinTypeAction -> {
            ObjectActionMixedIn mixedInAction = new ObjectActionMixedIn(mixinType, (String)mixinFacet.value(), (ObjectActionDefault)mixinTypeAction, this, this.servicesInjector);
            this.facetProcessor.processMemberOrder(mixedInAction);
            mixedInActionsToAppendTo.add(mixedInAction);
        });
    }

    @Override
    public Consent isValid(ManagedObject targetAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return this.isValidResult(targetAdapter, interactionInitiatedBy).createConsent();
    }

    @Override
    public InteractionResult isValidResult(ManagedObject targetAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectValidityContext validityContext = this.createValidityInteractionContext(targetAdapter, interactionInitiatedBy);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public ObjectValidityContext createValidityInteractionContext(ManagedObject targetAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return new ObjectValidityContext(targetAdapter, this.getIdentifier(), interactionInitiatedBy);
    }

    @Override
    public boolean isImmutable() {
        return this.containsFacet(ImmutableFacet.class);
    }

    @Override
    public boolean isHidden() {
        return this.containsFacet(HiddenFacet.class);
    }

    @Override
    public boolean isParseable() {
        return this.containsFacet(ParseableFacet.class);
    }

    @Override
    public boolean isEncodeable() {
        return this.containsFacet(EncodableFacet.class);
    }

    @Override
    public boolean isValue() {
        return this.containsFacet(ValueFacet.class);
    }

    @Override
    public boolean isParented() {
        return this.containsFacet(ParentedCollectionFacet.class);
    }

    @Override
    public boolean isParentedOrFreeCollection() {
        return this.containsFacet(CollectionFacet.class);
    }

    @Override
    public boolean isNotCollection() {
        return !this.isParentedOrFreeCollection();
    }

    @Override
    public boolean isValueOrIsParented() {
        return this.isValue() || this.isParented();
    }

    @Override
    public boolean isPersistenceCapable() {
        return this.containsFacet(JdoPersistenceCapableFacet.class);
    }

    @Override
    public boolean isPersistenceCapableOrViewModel() {
        return this.isViewModel() || this.isPersistenceCapable();
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.getFullIdentifier());
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardAgainstTooEarly_contrib(Contributed contributed) {
        if (contributed.isIncluded() && !this.contributeeAndMixedInActionsAdded) {
            List<ObjectAction> list = this.objectActions;
            synchronized (list) {
                ArrayList actions = _Lists.newArrayList(this.objectActions);
                if (this.isPersistenceCapableOrViewModel()) {
                    actions.addAll(this.createContributeeActions());
                    actions.addAll(this.createMixedInActions());
                }
                this.sortCacheAndUpdateActions(actions);
                this.contributeeAndMixedInActionsAdded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardAgainstTooEarly_assoz(Contributed contributed) {
        if (contributed.isIncluded() && !this.contributeeAndMixedInAssociationsAdded) {
            List<ObjectAssociation> list = this.associations;
            synchronized (list) {
                ArrayList associations = _Lists.newArrayList(this.associations);
                if (this.isPersistenceCapableOrViewModel()) {
                    associations.addAll(this.createContributeeAssociations());
                    associations.addAll(this.createMixedInAssociations());
                }
                this.sortAndUpdateAssociations(associations);
                this.contributeeAndMixedInAssociationsAdded = true;
            }
        }
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    private static class NotANoopFacetFilter<Q extends Facet>
    implements Predicate<Q> {
        Q noopFacet;

        private NotANoopFacetFilter() {
        }

        @Override
        public boolean test(Q facet) {
            if (facet == null) {
                return false;
            }
            if (!facet.isNoop()) {
                return true;
            }
            if (this.noopFacet == null) {
                this.noopFacet = facet;
            }
            return false;
        }
    }

    private static class SubclassList {
        private final List<ObjectSpecification> classes = _Lists.newArrayList();

        private SubclassList() {
        }

        public void addSubclass(ObjectSpecification subclass) {
            if (this.classes.contains(subclass)) {
                return;
            }
            this.classes.add(subclass);
        }

        public boolean hasSubclasses() {
            return !this.classes.isEmpty();
        }

        public List<ObjectSpecification> toList() {
            return Collections.unmodifiableList(this.classes);
        }
    }
}

