/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.Allow;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.interactions.ActionArgValidityContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;

public abstract class ObjectActionParameterAbstract
implements ObjectActionParameter {
    private final FeatureType featureType;
    private final int number;
    private final ObjectActionDefault parentAction;
    private final TypedHolder peer;

    protected ObjectActionParameterAbstract(FeatureType featureType, int number, ObjectActionDefault objectAction, TypedHolder peer) {
        this.featureType = featureType;
        this.number = number;
        this.parentAction = objectAction;
        this.peer = peer;
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public ObjectAdapter get(ObjectAdapter owner, InteractionInitiatedBy interactionInitiatedBy) {
        throw _Exceptions.unexpectedCodeReach();
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public ObjectAction getAction() {
        return this.parentAction;
    }

    public TypedHolder getPeer() {
        return this.peer;
    }

    @Override
    public ObjectSpecification getSpecification() {
        return ObjectMemberAbstract.getSpecification(this.getSpecificationLoader(), this.peer.getType());
    }

    @Override
    public Identifier getIdentifier() {
        return this.parentAction.getIdentifier();
    }

    @Override
    public String getId() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        if (facet != null && facet.value() != null) {
            return StringExtensions.asCamelLowerFirst(facet.value());
        }
        String name = this.getSpecification().getSingularName();
        List<ObjectActionParameter> parameters = this.getAction().getParameters(new Predicate<ObjectActionParameter>(){

            @Override
            public boolean test(ObjectActionParameter t) {
                return this.equalsShortIdentifier(t.getSpecification(), ObjectActionParameterAbstract.this.getSpecification());
            }

            protected boolean equalsShortIdentifier(ObjectSpecification spec1, ObjectSpecification spec2) {
                return spec1.getShortIdentifier().toLowerCase().equals(spec2.getShortIdentifier().toLowerCase());
            }
        });
        if (parameters.size() == 1) {
            return StringExtensions.asCamelLowerFirst(name);
        }
        int indexOf = parameters.indexOf(this);
        return StringExtensions.asCamelLowerFirst(name + (indexOf + 1));
    }

    @Override
    public String getName() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        if (facet != null && facet.value() != null) {
            return facet.value();
        }
        String name = this.getSpecification().getSingularName();
        List<ObjectActionParameter> parameters = this.getAction().getParameters(new Predicate<ObjectActionParameter>(){

            @Override
            public boolean test(ObjectActionParameter t) {
                return this.equalsShortIdentifier(t.getSpecification(), ObjectActionParameterAbstract.this.getSpecification());
            }

            protected boolean equalsShortIdentifier(ObjectSpecification spec1, ObjectSpecification spec2) {
                return spec1.getShortIdentifier().toLowerCase().equals(spec2.getShortIdentifier().toLowerCase());
            }
        });
        if (parameters.size() == 1) {
            return name;
        }
        int indexOf = parameters.indexOf(this);
        return name + " " + (indexOf + 1);
    }

    @Override
    public String getDescription() {
        DescribedAsFacet facet = this.getFacet(DescribedAsFacet.class);
        String description = (String)facet.value();
        return description == null ? "" : description;
    }

    @Override
    public boolean isOptional() {
        MandatoryFacet facet = this.getFacet(MandatoryFacet.class);
        return facet.isInvertedSemantics();
    }

    public Consent isUsable() {
        return Allow.DEFAULT;
    }

    protected FacetHolder getFacetHolder() {
        return this.peer;
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        FacetHolder facetHolder = this.getFacetHolder();
        return facetHolder != null && facetHolder.containsFacet(facetType);
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        FacetHolder facetHolder = this.getFacetHolder();
        return facetHolder != null && facetHolder.containsDoOpFacet(facetType);
    }

    @Override
    public boolean containsDoOpNotDerivedFacet(Class<? extends Facet> facetType) {
        FacetHolder facetHolder = this.getFacetHolder();
        return facetHolder != null && facetHolder.containsDoOpNotDerivedFacet(facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        FacetHolder facetHolder = this.getFacetHolder();
        return facetHolder != null ? (T)facetHolder.getFacet(cls) : null;
    }

    @Override
    public int getFacetCount() {
        FacetHolder facetHolder = this.getFacetHolder();
        return facetHolder != null ? facetHolder.getFacetCount() : 0;
    }

    @Override
    public Stream<Facet> streamFacets() {
        FacetHolder facetHolder = this.getFacetHolder();
        return facetHolder != null ? facetHolder.streamFacets() : Stream.of(new Facet[0]);
    }

    @Override
    public void addFacet(Facet facet) {
        FacetHolder facetHolder = this.getFacetHolder();
        if (facetHolder != null) {
            facetHolder.addFacet(facet);
        }
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        FacetHolder facetHolder = this.getFacetHolder();
        if (facetHolder != null) {
            facetHolder.addFacet(facet);
        }
    }

    @Override
    public void removeFacet(Facet facet) {
        FacetHolder facetHolder = this.getFacetHolder();
        if (facetHolder != null) {
            facetHolder.removeFacet(facet);
        }
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        FacetHolder facetHolder = this.getFacetHolder();
        if (facetHolder != null) {
            facetHolder.removeFacet(facetType);
        }
    }

    @Override
    public boolean hasAutoComplete() {
        ActionParameterAutoCompleteFacet facet = this.getFacet(ActionParameterAutoCompleteFacet.class);
        return facet != null;
    }

    @Override
    public ObjectAdapter[] getAutoComplete(ObjectAdapter adapter, String searchArg, InteractionInitiatedBy interactionInitiatedBy) {
        ArrayList adapters = _Lists.newArrayList();
        ActionParameterAutoCompleteFacet facet = this.getFacet(ActionParameterAutoCompleteFacet.class);
        if (facet != null) {
            Object[] choices = facet.autoComplete(adapter, searchArg, interactionInitiatedBy);
            ObjectActionParameterAbstract.checkChoicesOrAutoCompleteType(this.getSpecificationLoader(), choices, this.getSpecification());
            for (Object choice : choices) {
                adapters.add(this.getObjectAdapterProvider().adapterFor(choice));
            }
        }
        return adapters.toArray(new ObjectAdapter[0]);
    }

    @Override
    public int getAutoCompleteMinLength() {
        ActionParameterAutoCompleteFacet facet = this.getFacet(ActionParameterAutoCompleteFacet.class);
        return facet != null ? facet.getMinLength() : 1;
    }

    @Override
    public boolean hasChoices() {
        ActionParameterChoicesFacet choicesFacet = this.getFacet(ActionParameterChoicesFacet.class);
        return choicesFacet != null;
    }

    @Override
    public ObjectAdapter[] getChoices(ObjectAdapter adapter, ObjectAdapter[] argumentsIfAvailable, InteractionInitiatedBy interactionInitiatedBy) {
        List<ObjectAdapter> argListIfAvailable = ListExtensions.mutableCopy(argumentsIfAvailable);
        ObjectAdapter target = this.targetForDefaultOrChoices(adapter);
        List<ObjectAdapter> args = this.argsForDefaultOrChoices(adapter, argListIfAvailable);
        return this.findChoices(target, args, interactionInitiatedBy);
    }

    private ObjectAdapter[] findChoices(ObjectAdapter target, List<ObjectAdapter> args, InteractionInitiatedBy interactionInitiatedBy) {
        ArrayList adapters = _Lists.newArrayList();
        ActionParameterChoicesFacet facet = this.getFacet(ActionParameterChoicesFacet.class);
        if (facet != null) {
            Object[] choices = facet.getChoices(target, args, interactionInitiatedBy);
            ObjectActionParameterAbstract.checkChoicesOrAutoCompleteType(this.getSpecificationLoader(), choices, this.getSpecification());
            for (Object choice : choices) {
                ObjectAdapter adapter = choice != null ? this.getObjectAdapterProvider().adapterFor(choice) : null;
                adapters.add(adapter);
            }
        }
        return adapters.toArray(new ObjectAdapter[adapters.size()]);
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter adapter) {
        ObjectAdapter target = this.targetForDefaultOrChoices(adapter);
        List<ObjectAdapter> args = this.argsForDefaultOrChoices(adapter, null);
        return this.findDefault(target, args);
    }

    private ObjectAdapter findDefault(ObjectAdapter target, List<ObjectAdapter> args) {
        ActionParameterDefaultsFacet defaultsFacet = this.getFacet(ActionParameterDefaultsFacet.class);
        if (defaultsFacet != null) {
            Object dflt = defaultsFacet.getDefault(target, args);
            if (dflt == null) {
                return null;
            }
            return this.getObjectAdapterProvider().adapterFor(dflt);
        }
        return null;
    }

    protected ObjectAdapter targetForDefaultOrChoices(ObjectAdapter adapter) {
        return adapter;
    }

    protected List<ObjectAdapter> argsForDefaultOrChoices(ObjectAdapter adapter, List<ObjectAdapter> argumentsIfAvailable) {
        return argumentsIfAvailable;
    }

    static void checkChoicesOrAutoCompleteType(SpecificationLoader specificationLookup, Object[] objects, ObjectSpecification paramSpec) {
        for (Object object : objects) {
            ObjectSpecification paramWrappedSpec;
            if (object == null) continue;
            Class<?> choiceClass = object.getClass();
            Class<?> paramClass = paramSpec.getCorrespondingClass();
            Class<? extends Object> choiceWrappedClass = ClassExtensions.asWrappedIfNecessary(choiceClass);
            Class<? extends Object> paramWrappedClass = ClassExtensions.asWrappedIfNecessary(paramClass);
            ObjectSpecification choiceWrappedSpec = specificationLookup.loadSpecification(choiceWrappedClass);
            if (choiceWrappedSpec.isOfType(paramWrappedSpec = specificationLookup.loadSpecification(paramWrappedClass))) continue;
            throw new DomainModelException(String.format("Type incompatible with parameter type; expected %s, but was %s", paramSpec.getFullIdentifier(), choiceClass.getName()));
        }
    }

    private <T> void addAllInstancesForType(List<ObjectAdapter> adapters) {
        QueryFindAllInstances query = new QueryFindAllInstances(this.getSpecification().getFullIdentifier(), new long[0]);
        List<ObjectAdapter> allInstancesAdapter = this.getObjectPersistor().allMatchingQuery(query);
        for (ObjectAdapter choiceAdapter : allInstancesAdapter) {
            adapters.add(choiceAdapter);
        }
    }

    @Override
    public ActionArgValidityContext createProposedArgumentInteractionContext(ObjectAdapter objectAdapter, ObjectAdapter[] proposedArguments, int position, InteractionInitiatedBy interactionInitiatedBy) {
        return new ActionArgValidityContext(objectAdapter, this.parentAction, this.getIdentifier(), proposedArguments, position, interactionInitiatedBy);
    }

    @Override
    public String isValid(ObjectAdapter objectAdapter, Object proposedValue, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter proposedValueAdapter = null;
        if (proposedValue != null) {
            proposedValueAdapter = this.getObjectAdapterProvider().adapterFor(proposedValue);
            if (proposedValueAdapter == null) {
                return null;
            }
            ObjectSpecification proposedValueSpec = proposedValueAdapter.getSpecification();
            if (!proposedValueSpec.isOfType(proposedValueSpec)) {
                return null;
            }
        }
        ObjectAdapter[] argumentAdapters = this.arguments(proposedValueAdapter);
        ActionArgValidityContext ic = this.createProposedArgumentInteractionContext(objectAdapter, argumentAdapters, this.getNumber(), interactionInitiatedBy);
        InteractionResultSet buf = new InteractionResultSet();
        InteractionUtils.isValidResultSet(this, ic, buf);
        if (buf.isVetoed()) {
            return buf.getInteractionResult().getReason();
        }
        return null;
    }

    private ObjectAdapter[] arguments(ObjectAdapter proposedValue) {
        int parameterCount = this.getAction().getParameterCount();
        ObjectAdapter[] arguments = new ObjectAdapter[parameterCount];
        arguments[this.getNumber()] = proposedValue;
        return arguments;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.parentAction.getSpecificationLoader();
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.parentAction.getPersistenceSessionService();
    }

    protected PersistenceSessionServiceInternal getObjectPersistor() {
        return this.parentAction.getPersistenceSessionService();
    }
}

