/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderFacetComparator;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;

public interface ObjectMember
extends ObjectFeature {
    public String getHelp();

    public boolean isAlwaysHidden();

    public Consent isVisible(ManagedObject var1, InteractionInitiatedBy var2, Where var3);

    public Consent isUsable(ManagedObject var1, InteractionInitiatedBy var2, Where var3);

    public boolean isPropertyOrCollection();

    public boolean isOneToManyAssociation();

    public boolean isOneToOneAssociation();

    public boolean isAction();

    public static class Comparators {
        public static Comparator<ObjectMember> byMemberOrderSequence() {
            return new Comparator<ObjectMember>(){
                private final MemberOrderFacetComparator memberOrderFacetComparator = new MemberOrderFacetComparator(false);

                @Override
                public int compare(ObjectMember o1, ObjectMember o2) {
                    return this.memberOrderFacetComparator.compare(o1.getFacet(MemberOrderFacet.class), o2.getFacet(MemberOrderFacet.class));
                }
            };
        }
    }

    public static class Util {
        private Util() {
        }

        public static <T extends ObjectMember> Map<String, T> mapById(Stream<T> members) {
            LinkedHashMap memberById = _Maps.newLinkedHashMap();
            members.forEach(member -> {
                String id = Functions.getId().apply((ObjectMember)member);
                memberById.put(id, member);
            });
            return memberById;
        }
    }

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectMember, String> getId() {
            return ObjectFeature::getId;
        }
    }

    public static class DisabledException
    extends AuthorizationException {
        private static final long serialVersionUID = 1L;

        public DisabledException(String message) {
            super(message, null);
        }

        public static Predicate<Throwable> isInstanceOf() {
            return new Predicate<Throwable>(){

                @Override
                public boolean test(@Nullable Throwable throwable) {
                    return throwable instanceof DisabledException;
                }
            };
        }
    }

    public static class HiddenException
    extends AuthorizationException {
        private static final long serialVersionUID = 1L;

        public HiddenException() {
            super((RuntimeException)null);
        }

        public static Predicate<Throwable> isInstanceOf() {
            return new Predicate<Throwable>(){

                @Override
                public boolean test(@Nullable Throwable throwable) {
                    return throwable instanceof HiddenException;
                }
            };
        }
    }

    public static class AuthorizationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AuthorizationException() {
            this((RuntimeException)null);
        }

        public AuthorizationException(RuntimeException ex) {
            this("Not authorized or no such object", ex);
        }

        public AuthorizationException(String message, RuntimeException ex) {
            super(message, ex);
        }
    }
}

