/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.actions.action.associateWith.AssociatedWithFacet;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.facets.object.wizard.WizardFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderFacetComparator;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public interface ObjectAction
extends ObjectMember {
    public SemanticsOf getSemantics();

    public ObjectSpecification getOnType();

    public ActionType getType();

    public boolean isPrototype();

    public ObjectSpecification getReturnType();

    public boolean hasReturn();

    public ObjectAdapter executeWithRuleChecking(ObjectAdapter var1, ObjectAdapter var2, ObjectAdapter[] var3, InteractionInitiatedBy var4, Where var5) throws ObjectMember.AuthorizationException;

    public ObjectAdapter execute(ObjectAdapter var1, ObjectAdapter var2, ObjectAdapter[] var3, InteractionInitiatedBy var4);

    public Consent isProposedArgumentSetValid(ObjectAdapter var1, ObjectAdapter[] var2, InteractionInitiatedBy var3);

    public Consent isEachIndividualArgumentValid(ObjectAdapter var1, ObjectAdapter[] var2, InteractionInitiatedBy var3);

    public Consent isArgumentSetValid(ObjectAdapter var1, ObjectAdapter[] var2, InteractionInitiatedBy var3);

    public int getParameterCount();

    public List<ObjectActionParameter> getParameters();

    public List<ObjectSpecification> getParameterTypes();

    public List<ObjectActionParameter> getParameters(Predicate<ObjectActionParameter> var1);

    public ObjectActionParameter getParameterById(String var1);

    public ObjectActionParameter getParameterByName(String var1);

    public ObjectAdapter[] getDefaults(ObjectAdapter var1);

    public ObjectAdapter[][] getChoices(ObjectAdapter var1, InteractionInitiatedBy var2);

    public static final class Predicates {
        private Predicates() {
        }

        public static Predicate<ObjectAction> associatedWith(ObjectAssociation objectAssociation) {
            return new AssociatedWith(objectAssociation);
        }

        public static Predicate<ObjectAction> associatedWithAndWithCollectionParameterFor(OneToManyAssociation collection) {
            ObjectSpecification collectionTypeOfSpec = collection.getSpecification();
            return new AssociatedWith(collection).and(new HasParameterMatching(new ObjectActionParameter.Predicates.CollectionParameter(collectionTypeOfSpec)));
        }

        public static Predicate<ObjectAction> ofType(ActionType type) {
            return oa -> oa.getType() == type;
        }

        public static Predicate<ObjectAction> dynamicallyVisible(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy, Where where) {
            return objectAction -> {
                Consent visible = objectAction.isVisible(target, interactionInitiatedBy, where);
                return visible.isAllowed();
            };
        }

        public static Predicate<ObjectAction> excludeWizardActions(ObjectSpecification objectSpecification) {
            return Predicates.wizardActions(objectSpecification).negate();
        }

        private static Predicate<ObjectAction> wizardActions(ObjectSpecification objectSpecification) {
            return input -> {
                if (objectSpecification == null) {
                    return false;
                }
                WizardFacet wizardFacet = objectSpecification.getFacet(WizardFacet.class);
                return wizardFacet != null && wizardFacet.isWizardAction((ObjectAction)input);
            };
        }

        public static Predicate<ObjectAction> memberOrderOf(ObjectAssociation association) {
            String assocName = association.getName();
            String assocId = association.getId();
            return t -> {
                MemberOrderFacet memberOrderFacet = t.getFacet(MemberOrderFacet.class);
                if (memberOrderFacet == null || _Strings.isNullOrEmpty((CharSequence)memberOrderFacet.name())) {
                    return false;
                }
                String memberOrderName = memberOrderFacet.name().toLowerCase();
                if (_Strings.isNullOrEmpty((CharSequence)memberOrderName)) {
                    return false;
                }
                return memberOrderName.equalsIgnoreCase(assocName) || memberOrderName.equalsIgnoreCase(assocId);
            };
        }

        public static Predicate<ObjectAction> memberOrderNotAssociationOf(ObjectSpecification adapterSpec) {
            HashSet associationNamesAndIds = _Sets.newHashSet();
            adapterSpec.streamAssociations(Contributed.INCLUDED).forEach(ass -> {
                associationNamesAndIds.add(_Strings.lower((String)ass.getName()));
                associationNamesAndIds.add(_Strings.lower((String)ass.getId()));
            });
            return t -> {
                MemberOrderFacet memberOrderFacet = t.getFacet(MemberOrderFacet.class);
                if (memberOrderFacet == null || _Strings.isNullOrEmpty((CharSequence)memberOrderFacet.name())) {
                    return true;
                }
                String memberOrderName = memberOrderFacet.name().toLowerCase();
                if (_Strings.isNullOrEmpty((CharSequence)memberOrderName)) {
                    return false;
                }
                return !associationNamesAndIds.contains(memberOrderName);
            };
        }

        public static class HasParameterMatching
        implements Predicate<ObjectAction> {
            private final Predicate<ObjectActionParameter> parameterPredicate;

            public HasParameterMatching(Predicate<ObjectActionParameter> parameterPredicate) {
                this.parameterPredicate = parameterPredicate;
            }

            @Override
            public boolean test(ObjectAction objectAction) {
                return _NullSafe.stream(objectAction.getParameters()).anyMatch(this.parameterPredicate);
            }
        }

        public static class AssociatedWith
        implements Predicate<ObjectAction> {
            private final String memberId;
            private final String memberName;

            public AssociatedWith(ObjectAssociation objectAssociation) {
                this.memberId = objectAssociation.getId();
                this.memberName = objectAssociation.getName();
            }

            @Override
            public boolean test(ObjectAction objectAction) {
                AssociatedWithFacet associatedWithFacet = objectAction.getFacet(AssociatedWithFacet.class);
                if (associatedWithFacet == null) {
                    return false;
                }
                String associatedMemberName = (String)associatedWithFacet.value();
                if (associatedMemberName == null) {
                    return false;
                }
                String memberOrderNameLowerCase = associatedMemberName.toLowerCase();
                return this.memberName != null && Objects.equals(this.memberName.toLowerCase(), memberOrderNameLowerCase) || this.memberId != null && Objects.equals(this.memberId.toLowerCase(), memberOrderNameLowerCase);
            }
        }
    }

    public static final class Util {
        static final MemberOrderFacetComparator memberOrderFacetComparator = new MemberOrderFacetComparator(false);

        private Util() {
        }

        public static String nameFor(ObjectAction objAction) {
            String actionName = objAction.getName();
            if (actionName != null) {
                return actionName;
            }
            NamedFacet namedFacet = objAction.getFacet(NamedFacet.class);
            if (namedFacet != null) {
                return namedFacet.value();
            }
            return "(no name)";
        }

        public static SemanticsOf semanticsOf(ObjectAction objectAction) {
            return objectAction.getSemantics();
        }

        public static boolean isAreYouSureSemantics(ObjectAction objectAction) {
            return Util.semanticsOf(objectAction).isAreYouSure();
        }

        public static boolean isIdempotentOrCachable(ObjectAction objectAction) {
            SemanticsOf semantics = Util.semanticsOf(objectAction);
            return semantics.isIdempotentInNature() || semantics.isSafeAndRequestCacheable();
        }

        public static boolean isNoParameters(ObjectAction objectAction) {
            return objectAction.getParameterCount() == 0;
        }

        public static boolean returnsBlobOrClob(ObjectAction objectAction) {
            Class<?> cls;
            ObjectSpecification returnType = objectAction.getReturnType();
            return returnType != null && (Blob.class.isAssignableFrom(cls = returnType.getCorrespondingClass()) || Clob.class.isAssignableFrom(cls));
        }

        public static String actionIdentifierFor(ObjectAction action) {
            Identifier identifier = action.getIdentifier();
            String className = action.getOnType().getSpecId().asString().replace(".", "-");
            String actionId = action.getId();
            return className + "-" + actionId;
        }

        public static String descriptionOf(ObjectAction action) {
            return action.getDescription();
        }

        public static ActionLayout.Position actionLayoutPositionOf(ObjectAction action) {
            ActionPositionFacet layoutFacet = action.getFacet(ActionPositionFacet.class);
            return layoutFacet != null ? layoutFacet.position() : ActionLayout.Position.BELOW;
        }

        public static String cssClassFaFor(ObjectAction action) {
            CssClassFaFacet cssClassFaFacet = action.getFacet(CssClassFaFacet.class);
            return cssClassFaFacet != null ? (String)cssClassFaFacet.value() : null;
        }

        public static CssClassFaPosition cssClassFaPositionFor(ObjectAction action) {
            CssClassFaFacet facet = action.getFacet(CssClassFaFacet.class);
            return facet != null ? facet.getPosition() : CssClassFaPosition.LEFT;
        }

        public static String cssClassFor(ObjectAction action, ObjectAdapter objectAdapter) {
            CssClassFacet cssClassFacet = action.getFacet(CssClassFacet.class);
            return cssClassFacet != null ? cssClassFacet.cssClass(objectAdapter) : null;
        }

        public static List<ObjectAction> findTopLevel(ObjectAdapter adapter) {
            ArrayList topLevelActions = _Lists.newArrayList();
            Util.addTopLevelActions(adapter, ActionType.USER, topLevelActions);
            if (_Context.isPrototyping()) {
                Util.addTopLevelActions(adapter, ActionType.PROTOTYPE, topLevelActions);
            }
            return topLevelActions;
        }

        static void addTopLevelActions(ObjectAdapter adapter, ActionType actionType, List<ObjectAction> topLevelActions) {
            ObjectSpecification adapterSpec = adapter.getSpecification();
            Predicate<ObjectAction> predicate = Predicates.memberOrderNotAssociationOf(adapterSpec).and(Predicates.dynamicallyVisible(adapter, InteractionInitiatedBy.USER, Where.ANYWHERE)).and(Predicates.excludeWizardActions(adapterSpec));
            Stream<ObjectAction> userActions = adapterSpec.streamObjectActions(actionType, Contributed.INCLUDED).filter(predicate);
            userActions.forEach(topLevelActions::add);
        }

        public static List<ObjectAction> findForAssociation(ObjectAdapter adapter, ObjectAssociation association) {
            ArrayList associatedActions = _Lists.newArrayList();
            Util.addActions(adapter, ActionType.USER, association, associatedActions);
            if (_Context.isPrototyping()) {
                Util.addActions(adapter, ActionType.PROTOTYPE, association, associatedActions);
            }
            Collections.sort(associatedActions, new Comparator<ObjectAction>(){

                @Override
                public int compare(ObjectAction o1, ObjectAction o2) {
                    MemberOrderFacet m1 = o1.getFacet(MemberOrderFacet.class);
                    MemberOrderFacet m2 = o2.getFacet(MemberOrderFacet.class);
                    return memberOrderFacetComparator.compare(m1, m2);
                }
            });
            return associatedActions;
        }

        static void addActions(ObjectAdapter adapter, ActionType type, ObjectAssociation association, List<ObjectAction> associatedActions) {
            ObjectSpecification objectSpecification = adapter.getSpecification();
            Predicate<ObjectAction> predicate = Predicates.memberOrderOf(association).and(Predicates.excludeWizardActions(objectSpecification));
            Stream<ObjectAction> userActions = objectSpecification.streamObjectActions(type, Contributed.INCLUDED).filter(predicate);
            userActions.forEach(associatedActions::add);
        }

        public static PromptStyle promptStyleFor(ObjectAction objectAction) {
            PromptStyleFacet facet = objectAction.getFacet(PromptStyleFacet.class);
            if (facet == null) {
                return PromptStyle.INLINE;
            }
            PromptStyle promptStyle = facet.value();
            if (promptStyle == PromptStyle.AS_CONFIGURED) {
                return PromptStyle.INLINE;
            }
            return promptStyle;
        }

        public static Optional<String> targetNameFor(ObjectAction owningAction, @Nullable ObjectAdapter mixedInAdapter) {
            if (mixedInAdapter != null) {
                ObjectSpecification onType = owningAction.getOnType();
                ObjectSpecification mixedInSpec = mixedInAdapter.getSpecification();
                Optional<String> mixinName = mixedInSpec.getMixedInMember(onType).map(ObjectFeature::getName);
                return mixinName;
            }
            return Optional.empty();
        }
    }
}

