/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import org.apache.isis.commons.internal.functions._Predicates;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.spec.DefaultProvider;
import org.apache.isis.core.metamodel.spec.Hierarchical;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.Specification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionContainer;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociationContainer;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.specimpl.MixedInMember;
import org.apache.isis.core.security.authentication.AuthenticationSession;

public interface ObjectSpecification
extends Specification,
ObjectActionContainer,
ObjectAssociationContainer,
Hierarchical,
DefaultProvider {
    public ObjectMember getMember(String var1);

    default public Optional<MixedInMember> getMixedInMember(ObjectSpecification onType) {
        return this.streamObjectActions(Contributed.INCLUDED).filter(_Predicates.instanceOf(MixedInMember.class)).map(member -> (MixedInMember)((Object)member)).filter(member -> member.getMixinType() == onType).findAny();
    }

    public Class<?> getCorrespondingClass();

    public ObjectSpecId getSpecId();

    public String getFullIdentifier();

    public String getShortIdentifier();

    public String getSingularName();

    public String getPluralName();

    @Override
    public String getDescription();

    public String getHelp();

    public String getTitle(ManagedObject var1, ManagedObject var2);

    public String getIconName(ManagedObject var1);

    public Object getNavigableParent(Object var1);

    public String getCssClass(ManagedObject var1);

    public boolean isAbstract();

    public ObjectSpecification getElementSpecification();

    public ObjectTitleContext createTitleInteractionContext(AuthenticationSession var1, InteractionInitiatedBy var2, ManagedObject var3);

    public ObjectValidityContext createValidityInteractionContext(ManagedObject var1, InteractionInitiatedBy var2);

    public Consent isValid(ManagedObject var1, InteractionInitiatedBy var2);

    public InteractionResult isValidResult(ManagedObject var1, InteractionInitiatedBy var2);

    public boolean isNotCollection();

    public boolean isParentedOrFreeCollection();

    public boolean isValue();

    public boolean isParented();

    public boolean isValueOrIsParented();

    public boolean isParseable();

    public boolean isEncodeable();

    public boolean isImmutable();

    public boolean isHidden();

    public boolean isService();

    public boolean isViewModel();

    public boolean isMixin();

    public boolean isViewModelCloneable(ManagedObject var1);

    public boolean isWizard();

    public boolean isPersistenceCapable();

    public boolean isPersistenceCapableOrViewModel();

    public static final class Functions {
        public static final Function<ObjectSpecification, String> FULL_IDENTIFIER = ObjectSpecification::getFullIdentifier;

        private Functions() {
        }
    }

    public static final class Comparators {
        public static final Comparator<ObjectSpecification> FULLY_QUALIFIED_CLASS_NAME = (o1, o2) -> o1.getFullIdentifier().compareTo(o2.getFullIdentifier());
        public static final Comparator<ObjectSpecification> SHORT_IDENTIFIER_IGNORE_CASE = (s1, s2) -> s1.getShortIdentifier().compareToIgnoreCase(s2.getShortIdentifier());

        private Comparators() {
        }
    }
}

