/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec;

import java.util.AbstractList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class FreeStandingList
extends AbstractList<ManagedObject> {
    private final List<ManagedObject> instances;
    private final ObjectSpecification instanceSpecification;

    public static <T extends ManagedObject> FreeStandingList of(ObjectSpecification instanceSpecification, List<T> instances) {
        return new FreeStandingList(instanceSpecification, instances.stream().map(x -> x).collect(Collectors.toList()));
    }

    private FreeStandingList(ObjectSpecification instanceSpecification, List<ManagedObject> instances) {
        this.instanceSpecification = instanceSpecification;
        this.instances = instances;
    }

    @Override
    public ManagedObject get(int index) {
        return this.instances.get(index);
    }

    @Override
    public int size() {
        return this.instances.size();
    }

    public ObjectSpecification getElementSpecification() {
        return this.instanceSpecification;
    }

    public String titleString() {
        return this.instanceSpecification.getPluralName() + ", " + this.size();
    }

    @Override
    public String toString() {
        String title;
        ToString s = new ToString(this);
        s.append("elements", this.instanceSpecification.getFullIdentifier());
        try {
            title = "'" + this.titleString() + "'";
        }
        catch (NullPointerException e) {
            title = "none";
        }
        s.append("title", title);
        s.append("vector", this.instances);
        return s.toString();
    }
}

