/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.services.swagger.internal.ValuePropertyFactory;

public interface ValuePropertyPlugin {
    public static ValuePropertyCollector collector() {
        return new ValuePropertyCollector(){
            final Map<Class<?>, ValuePropertyFactory.Factory> entries = _Maps.newHashMap();

            @Override
            public void visitEntries(BiConsumer<Class<?>, ValuePropertyFactory.Factory> visitor) {
                Objects.requireNonNull(visitor);
                this.entries.forEach(visitor);
            }

            @Override
            public void addValueProperty(Class<?> cls, ValuePropertyFactory.Factory factory) {
                Objects.requireNonNull(cls);
                Objects.requireNonNull(factory);
                this.entries.put(cls, factory);
            }
        };
    }

    public void plugin(ValuePropertyCollector var1);

    public static interface ValuePropertyCollector {
        public void addValueProperty(Class<?> var1, ValuePropertyFactory.Factory var2);

        public void visitEntries(BiConsumer<Class<?>, ValuePropertyFactory.Factory> var1);
    }
}

