/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.registry;

import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ServiceRegistryDefault
implements ServiceRegistry,
ServicesInjectorAware {
    @Inject
    WrapperFactory wrapperFactory;
    private ServicesInjector servicesInjector;

    @Programmatic
    public <T> T injectServicesInto(T domainObject) {
        this.servicesInjector.injectServicesInto(this.unwrapped(domainObject));
        return domainObject;
    }

    @Programmatic
    public <T> Stream<T> streamServices(Class<T> serviceType) {
        return this.servicesInjector.streamServices(serviceType);
    }

    @Programmatic
    public Stream<Object> streamServices() {
        return this.servicesInjector.streamServices();
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

