/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.grid.bootstrap3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.ActionLayoutDataOwner;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Grid;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowContentOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.Size;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.members.order.annotprop.MemberOrderFacetAnnotation;
import org.apache.isis.core.metamodel.services.grid.GridSystemServiceAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class GridSystemServiceBS3
extends GridSystemServiceAbstract<BS3Grid> {
    public static final String TNS = "http://isis.apache.org/applib/layout/grid/bootstrap3";
    public static final String SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/grid/bootstrap3/bootstrap3.xsd";

    public GridSystemServiceBS3() {
        super(BS3Grid.class, TNS, SCHEMA_LOCATION);
    }

    @Programmatic
    public BS3Grid defaultGrid(Class<?> domainClass) {
        BS3Grid bs3Grid = new BS3Grid();
        bs3Grid.setDomainClass(domainClass);
        BS3Row headerRow = new BS3Row();
        bs3Grid.getRows().add(headerRow);
        BS3Col headerRowCol = new BS3Col();
        headerRowCol.setSpan(12);
        headerRowCol.setUnreferencedActions(Boolean.valueOf(true));
        headerRowCol.setDomainObject(new DomainObjectLayoutData());
        headerRow.getCols().add(headerRowCol);
        BS3Row propsRow = new BS3Row();
        bs3Grid.getRows().add(propsRow);
        GridSystemServiceBS3.addFieldSetsToColumn(propsRow, 4, Arrays.asList("General"), true);
        BS3Col col = new BS3Col();
        col.setUnreferencedCollections(Boolean.valueOf(true));
        col.setSpan(12);
        propsRow.getCols().add(col);
        return bs3Grid;
    }

    static void addFieldSetsToColumn(BS3Row propsRow, int span, List<String> memberGroupNames, boolean unreferencedProperties) {
        if (span > 0 || unreferencedProperties) {
            BS3Col col = new BS3Col();
            col.setSpan(span);
            propsRow.getCols().add(col);
            List<String> leftMemberGroups = memberGroupNames;
            for (String memberGroup : leftMemberGroups) {
                FieldSet fieldSet = new FieldSet();
                fieldSet.setName(memberGroup);
                if (unreferencedProperties && col.getFieldSets().isEmpty()) {
                    fieldSet.setUnreferencedProperties(Boolean.valueOf(true));
                }
                col.getFieldSets().add(fieldSet);
            }
        }
    }

    @Override
    protected boolean validateAndNormalize(Grid grid, Class<?> domainClass) {
        ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(domainClass);
        Map<String, OneToOneAssociation> oneToOneAssociationById = ObjectMember.Util.mapById(GridSystemServiceBS3.getOneToOneAssociations(objectSpec));
        Map<String, OneToManyAssociation> oneToManyAssociationById = ObjectMember.Util.mapById(GridSystemServiceBS3.getOneToManyAssociations(objectSpec));
        Map<String, ObjectAction> objectActionById = ObjectMember.Util.mapById(objectSpec.streamObjectActions(Contributed.INCLUDED));
        BS3Grid bs3Grid = (BS3Grid)grid;
        LinkedHashMap propertyLayoutDataById = bs3Grid.getAllPropertiesById();
        LinkedHashMap collectionLayoutDataById = bs3Grid.getAllCollectionsById();
        LinkedHashMap actionLayoutDataById = bs3Grid.getAllActionsById();
        final ArrayList gridIds = _Lists.newArrayList();
        final LinkedHashMap rowIds = _Maps.newLinkedHashMap();
        final LinkedHashMap colIds = _Maps.newLinkedHashMap();
        final LinkedHashMap fieldSetIds = _Maps.newLinkedHashMap();
        final boolean[] duplicateIdDetected = new boolean[]{false};
        bs3Grid.visit((Grid.Visitor)new BS3Grid.VisitorAdapter(){

            public void visit(BS3Row bs3Row) {
                String id = bs3Row.getId();
                if (id == null) {
                    return;
                }
                if (gridIds.contains(id)) {
                    bs3Row.setMetadataError("There is another element in the grid with this id");
                    duplicateIdDetected[0] = true;
                    return;
                }
                rowIds.put(id, bs3Row);
                gridIds.add(id);
            }

            public void visit(BS3Col bs3Col) {
                String id = bs3Col.getId();
                if (id == null) {
                    return;
                }
                if (gridIds.contains(id)) {
                    bs3Col.setMetadataError("There is another element in the grid with this id");
                    duplicateIdDetected[0] = true;
                    return;
                }
                colIds.put(id, bs3Col);
                gridIds.add(id);
            }

            public void visit(FieldSet fieldSet) {
                String id = fieldSet.getId();
                if (id == null) {
                    String name = fieldSet.getName();
                    id = GridSystemServiceBS3.asId(name);
                    fieldSet.setId(id);
                }
                if (gridIds.contains(id)) {
                    fieldSet.setMetadataError("There is another element in the grid with this id");
                    duplicateIdDetected[0] = true;
                    return;
                }
                fieldSetIds.put(id, fieldSet);
                gridIds.add(id);
            }
        });
        if (duplicateIdDetected[0]) {
            return false;
        }
        final GridVisitorResult result = new GridVisitorResult();
        bs3Grid.visit((Grid.Visitor)new BS3Grid.VisitorAdapter(){

            public void visit(BS3Col bs3Col) {
                if (GridSystemServiceBS3.isSet(bs3Col.isUnreferencedActions()).booleanValue()) {
                    if (result.colForUnreferencedActionsRef != null) {
                        bs3Col.setMetadataError("More than one col with 'unreferencedActions' attribute set");
                    } else if (result.fieldSetForUnreferencedActionsRef != null) {
                        bs3Col.setMetadataError("Already found a fieldset with 'unreferencedActions' attribute set");
                    } else {
                        result.colForUnreferencedActionsRef = bs3Col;
                    }
                }
                if (GridSystemServiceBS3.isSet(bs3Col.isUnreferencedCollections()).booleanValue()) {
                    if (result.colForUnreferencedCollectionsRef != null) {
                        bs3Col.setMetadataError("More than one col with 'unreferencedCollections' attribute set");
                    } else if (result.tabGroupForUnreferencedCollectionsRef != null) {
                        bs3Col.setMetadataError("Already found a tabgroup with 'unreferencedCollections' attribute set");
                    } else {
                        result.colForUnreferencedCollectionsRef = bs3Col;
                    }
                }
            }

            public void visit(FieldSet fieldSet) {
                if (GridSystemServiceBS3.isSet(fieldSet.isUnreferencedActions()).booleanValue()) {
                    if (result.fieldSetForUnreferencedActionsRef != null) {
                        fieldSet.setMetadataError("More than one fieldset with 'unreferencedActions' attribute set");
                    } else if (result.colForUnreferencedActionsRef != null) {
                        fieldSet.setMetadataError("Already found a column with 'unreferencedActions' attribute set");
                    } else {
                        result.fieldSetForUnreferencedActionsRef = fieldSet;
                    }
                }
                if (GridSystemServiceBS3.isSet(fieldSet.isUnreferencedProperties()).booleanValue()) {
                    if (result.fieldSetForUnreferencedPropertiesRef != null) {
                        fieldSet.setMetadataError("More than one col with 'unreferencedProperties' attribute set");
                    } else {
                        result.fieldSetForUnreferencedPropertiesRef = fieldSet;
                    }
                }
            }

            public void visit(BS3TabGroup bs3TabGroup) {
                if (GridSystemServiceBS3.isSet(bs3TabGroup.isUnreferencedCollections()).booleanValue()) {
                    if (result.tabGroupForUnreferencedCollectionsRef != null) {
                        bs3TabGroup.setMetadataError("More than one tabgroup with 'unreferencedCollections' attribute set");
                    } else if (result.colForUnreferencedCollectionsRef != null) {
                        bs3TabGroup.setMetadataError("Already found a column with 'unreferencedCollections' attribute set");
                    } else {
                        result.tabGroupForUnreferencedCollectionsRef = bs3TabGroup;
                    }
                }
            }
        });
        if (result.colForUnreferencedActionsRef == null && result.fieldSetForUnreferencedActionsRef == null) {
            bs3Grid.getMetadataErrors().add("No column and also no fieldset found with the 'unreferencedActions' attribute set");
        }
        if (result.fieldSetForUnreferencedPropertiesRef == null) {
            bs3Grid.getMetadataErrors().add("No fieldset found with the 'unreferencedProperties' attribute set");
        }
        if (result.colForUnreferencedCollectionsRef == null && result.tabGroupForUnreferencedCollectionsRef == null) {
            bs3Grid.getMetadataErrors().add("No column and also no tabgroup found with the 'unreferencedCollections' attribute set");
        }
        if (result.colForUnreferencedActionsRef == null && result.fieldSetForUnreferencedActionsRef == null || result.fieldSetForUnreferencedPropertiesRef == null || result.colForUnreferencedCollectionsRef == null && result.tabGroupForUnreferencedCollectionsRef == null) {
            return false;
        }
        GridSystemServiceAbstract.Tuple<List<String>> propertyIdTuple = GridSystemServiceBS3.surplusAndMissing(propertyLayoutDataById.keySet(), oneToOneAssociationById.keySet());
        List surplusPropertyIds = (List)propertyIdTuple.first;
        List missingPropertyIds = (List)propertyIdTuple.second;
        for (Iterator<OneToOneAssociation> surplusPropertyId : surplusPropertyIds) {
            ((PropertyLayoutData)propertyLayoutDataById.get(surplusPropertyId)).setMetadataError("No such property");
        }
        HashMap boundAssociationIdsByFieldSetId = _Maps.newHashMap();
        for (FieldSet fieldSet : fieldSetIds.values()) {
            String fieldSetId = fieldSet.getId();
            Set boundAssociationIds = (Set)boundAssociationIdsByFieldSetId.get(fieldSetId);
            if (boundAssociationIds != null) continue;
            boundAssociationIds = _NullSafe.stream((Collection)fieldSet.getProperties()).map(PropertyLayoutData::getId).collect(Collectors.toCollection(_Sets::newLinkedHashSet));
            boundAssociationIdsByFieldSetId.put(fieldSetId, boundAssociationIds);
        }
        for (OneToOneAssociation oneToOneAssociation : oneToOneAssociationById.values()) {
            String id;
            MemberOrderFacet memberOrderFacet = oneToOneAssociation.getFacet(MemberOrderFacet.class);
            if (memberOrderFacet == null || !fieldSetIds.containsKey(id = GridSystemServiceBS3.asId(memberOrderFacet.name()))) continue;
            Set boundAssociationIds = (Set)boundAssociationIdsByFieldSetId.get(id);
            if (boundAssociationIds == null) {
                boundAssociationIds = _Sets.newLinkedHashSet();
                boundAssociationIdsByFieldSetId.put(id, boundAssociationIds);
            }
            boundAssociationIds.add(oneToOneAssociation.getId());
        }
        if (!missingPropertyIds.isEmpty()) {
            FieldSet fieldSet;
            ArrayList unboundPropertyIds = _Lists.newArrayList((Collection)missingPropertyIds);
            for (String fieldSetId : boundAssociationIdsByFieldSetId.keySet()) {
                Set boundPropertyIds = (Set)boundAssociationIdsByFieldSetId.get(fieldSetId);
                unboundPropertyIds.removeAll(boundPropertyIds);
            }
            for (String fieldSetId : boundAssociationIdsByFieldSetId.keySet()) {
                FieldSet fieldSet2 = (FieldSet)fieldSetIds.get(fieldSetId);
                Set associationIds = (Set)boundAssociationIdsByFieldSetId.get(fieldSetId);
                List associations = associationIds.stream().map(propertyId -> (OneToOneAssociation)oneToOneAssociationById.get(propertyId)).filter(_NullSafe::isPresent).collect(Collectors.toList());
                Collections.sort(associations, ObjectMember.Comparators.byMemberOrderSequence());
                this.addPropertiesTo(fieldSet2, _Lists.map(associations, ObjectFeature::getId), propertyLayoutDataById);
            }
            if (!unboundPropertyIds.isEmpty() && (fieldSet = result.fieldSetForUnreferencedPropertiesRef) != null) {
                this.addPropertiesTo(fieldSet, unboundPropertyIds, propertyLayoutDataById);
            }
        }
        GridSystemServiceAbstract.Tuple<List<String>> collectionIdTuple = GridSystemServiceBS3.surplusAndMissing(collectionLayoutDataById.keySet(), oneToManyAssociationById.keySet());
        List list = (List)collectionIdTuple.first;
        List missingCollectionIds = (List)collectionIdTuple.second;
        for (String surplusCollectionId : list) {
            ((CollectionLayoutData)collectionLayoutDataById.get(surplusCollectionId)).setMetadataError("No such collection");
        }
        if (!missingCollectionIds.isEmpty()) {
            List sortedCollections = _Lists.map((Collection)missingCollectionIds, oneToManyAssociationById::get);
            sortedCollections.sort(ObjectMember.Comparators.byMemberOrderSequence());
            List sortedMissingCollectionIds = _Lists.map((Collection)sortedCollections, ObjectFeature::getId);
            BS3TabGroup bs3TabGroup = result.tabGroupForUnreferencedCollectionsRef;
            if (bs3TabGroup != null) {
                this.addCollectionsTo(bs3TabGroup, (List<String>)sortedMissingCollectionIds, objectSpec);
            } else {
                BS3Col bs3Col = result.colForUnreferencedCollectionsRef;
                if (bs3Col != null) {
                    this.addCollectionsTo(bs3Col, (List<String>)sortedMissingCollectionIds, collectionLayoutDataById);
                }
            }
        }
        GridSystemServiceAbstract.Tuple<List<String>> actionIdTuple = GridSystemServiceBS3.surplusAndMissing(actionLayoutDataById.keySet(), objectActionById.keySet());
        List surplusActionIds = (List)actionIdTuple.first;
        List possiblyMissingActionIds = (List)actionIdTuple.second;
        ArrayList associatedActionIds = _Lists.newArrayList();
        List sortedPossiblyMissingActions = _Lists.map((Collection)possiblyMissingActionIds, objectActionById::get);
        sortedPossiblyMissingActions.sort(ObjectMember.Comparators.byMemberOrderSequence());
        List sortedPossiblyMissingActionIds = _Lists.map((Collection)sortedPossiblyMissingActions, ObjectFeature::getId);
        for (Object actionId : sortedPossiblyMissingActionIds) {
            ActionLayoutData actionLayoutData;
            String memberOrderName;
            ObjectAction oa = objectActionById.get(actionId);
            MemberOrderFacet memberOrderFacet = oa.getFacet(MemberOrderFacet.class);
            if (memberOrderFacet == null || (memberOrderName = memberOrderFacet.name()) == null) continue;
            String id = GridSystemServiceBS3.asId(memberOrderName);
            if (oneToOneAssociationById.containsKey(id)) {
                PropertyLayoutData owner;
                ActionLayout.Position position;
                associatedActionIds.add(actionId);
                if (memberOrderFacet instanceof MemberOrderFacetAnnotation) continue;
                PropertyLayoutData propertyLayoutData = (PropertyLayoutData)propertyLayoutDataById.get(id);
                actionLayoutData = new ActionLayoutData((String)actionId);
                ActionPositionFacet actionPositionFacet = oa.getFacet(ActionPositionFacet.class);
                if (actionPositionFacet != null) {
                    position = actionPositionFacet.position();
                    owner = position == ActionLayout.Position.PANEL || position == ActionLayout.Position.PANEL_DROPDOWN ? propertyLayoutData.getOwner() : propertyLayoutData;
                } else {
                    position = ActionLayout.Position.BELOW;
                    owner = propertyLayoutData;
                }
                actionLayoutData.setPosition(position);
                this.addActionTo((ActionLayoutDataOwner)owner, actionLayoutData);
                continue;
            }
            if (oneToManyAssociationById.containsKey(id)) {
                associatedActionIds.add(actionId);
                if (memberOrderFacet instanceof MemberOrderFacetAnnotation) continue;
                CollectionLayoutData collectionLayoutData = (CollectionLayoutData)collectionLayoutDataById.get(id);
                actionLayoutData = new ActionLayoutData((String)actionId);
                this.addActionTo((ActionLayoutDataOwner)collectionLayoutData, actionLayoutData);
                continue;
            }
            Set boundAssociationIds = (Set)boundAssociationIdsByFieldSetId.get(id);
            if (boundAssociationIds == null || boundAssociationIds.isEmpty()) continue;
            associatedActionIds.add(actionId);
            actionLayoutData = new ActionLayoutData((String)actionId);
            actionLayoutData.setPosition(ActionLayout.Position.PANEL_DROPDOWN);
            FieldSet fieldSet = (FieldSet)fieldSetIds.get(id);
            this.addActionTo((ActionLayoutDataOwner)fieldSet, actionLayoutData);
        }
        ArrayList missingActionIds = _Lists.newArrayList((Collection)sortedPossiblyMissingActionIds);
        missingActionIds.removeAll(associatedActionIds);
        for (String surplusActionId : surplusActionIds) {
            ((ActionLayoutData)actionLayoutDataById.get(surplusActionId)).setMetadataError("No such action");
        }
        if (!missingActionIds.isEmpty()) {
            BS3Col bs3Col = result.colForUnreferencedActionsRef;
            if (bs3Col != null) {
                this.addActionsTo(bs3Col, (List<String>)missingActionIds, (LinkedHashMap<String, ActionLayoutData>)actionLayoutDataById);
            } else {
                FieldSet fieldSet = result.fieldSetForUnreferencedActionsRef;
                if (fieldSet != null) {
                    this.addActionsTo(fieldSet, (List<String>)missingActionIds, (LinkedHashMap<String, ActionLayoutData>)actionLayoutDataById);
                }
            }
        }
        return true;
    }

    protected void addPropertiesTo(FieldSet fieldSet, List<String> propertyIds, LinkedHashMap<String, PropertyLayoutData> propertyLayoutDataById) {
        Set existingIds = _NullSafe.stream((Collection)fieldSet.getProperties()).map(PropertyLayoutData::getId).collect(Collectors.toSet());
        for (String propertyId : propertyIds) {
            if (existingIds.contains(propertyId)) continue;
            PropertyLayoutData propertyLayoutData = new PropertyLayoutData(propertyId);
            fieldSet.getProperties().add(propertyLayoutData);
            propertyLayoutData.setOwner(fieldSet);
            propertyLayoutDataById.put(propertyId, propertyLayoutData);
        }
    }

    protected void addCollectionsTo(BS3Col tabRowCol, List<String> collectionIds, LinkedHashMap<String, CollectionLayoutData> collectionLayoutDataById) {
        for (String collectionId : collectionIds) {
            CollectionLayoutData collectionLayoutData = new CollectionLayoutData(collectionId);
            collectionLayoutData.setDefaultView("table");
            tabRowCol.getCollections().add(collectionLayoutData);
            collectionLayoutDataById.put(collectionId, collectionLayoutData);
        }
    }

    protected void addCollectionsTo(BS3TabGroup tabGroup, List<String> collectionIds, ObjectSpecification objectSpec) {
        for (String collectionId : collectionIds) {
            BS3Tab bs3Tab = new BS3Tab();
            bs3Tab.setName(objectSpec.getAssociation(collectionId).getName());
            tabGroup.getTabs().add(bs3Tab);
            bs3Tab.setOwner((BS3TabOwner)tabGroup);
            BS3Row tabRow = new BS3Row();
            tabRow.setOwner((BS3RowOwner)bs3Tab);
            bs3Tab.getRows().add(tabRow);
            BS3Col tabRowCol = new BS3Col();
            tabRowCol.setSpan(12);
            tabRowCol.setSize(Size.MD);
            tabRowCol.setOwner((BS3RowContentOwner)tabRow);
            tabRow.getCols().add(tabRowCol);
            CollectionLayoutData layoutMetadata = new CollectionLayoutData(collectionId);
            layoutMetadata.setDefaultView("table");
            tabRowCol.getCollections().add(layoutMetadata);
        }
    }

    protected void addActionsTo(BS3Col bs3Col, List<String> actionIds, LinkedHashMap<String, ActionLayoutData> actionLayoutDataById) {
        for (String actionId : actionIds) {
            ActionLayoutData actionLayoutData = new ActionLayoutData(actionId);
            this.addActionTo((ActionLayoutDataOwner)bs3Col, actionLayoutData);
            actionLayoutDataById.put(actionId, actionLayoutData);
        }
    }

    protected void addActionsTo(FieldSet fieldSet, List<String> actionIds, LinkedHashMap<String, ActionLayoutData> actionLayoutDataById) {
        for (String actionId : actionIds) {
            ActionLayoutData actionLayoutData = new ActionLayoutData(actionId);
            this.addActionTo((ActionLayoutDataOwner)fieldSet, actionLayoutData);
            actionLayoutDataById.put(actionId, actionLayoutData);
        }
    }

    protected void addActionTo(ActionLayoutDataOwner owner, ActionLayoutData actionLayoutData) {
        List actions = owner.getActions();
        if (actions == null) {
            actions = _Lists.newArrayList();
            owner.setActions(actions);
        }
        actions.add(actionLayoutData);
        actionLayoutData.setOwner(owner);
    }

    private static Boolean isSet(Boolean flag) {
        return flag != null && flag != false;
    }

    private static String asId(String str) {
        if (_Strings.isNullOrEmpty((CharSequence)str)) {
            return str;
        }
        char c = str.charAt(0);
        return Character.toLowerCase(c) + str.substring(1).replaceAll("\\s+", "");
    }

    private static final class GridVisitorResult {
        BS3Col colForUnreferencedActionsRef;
        BS3Col colForUnreferencedCollectionsRef;
        FieldSet fieldSetForUnreferencedActionsRef;
        FieldSet fieldSetForUnreferencedPropertiesRef;
        BS3TabGroup tabGroupForUnreferencedCollectionsRef;

        private GridVisitorResult() {
        }
    }
}

