/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.LabelPosition;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.RenderDay;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.ActionLayoutDataOwner;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutDataOwner;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.HasBookmarking;
import org.apache.isis.applib.layout.component.HasCssClass;
import org.apache.isis.applib.layout.component.HasCssClassFa;
import org.apache.isis.applib.layout.component.HasDescribedAs;
import org.apache.isis.applib.layout.component.HasHidden;
import org.apache.isis.applib.layout.component.HasNamed;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.services.grid.GridSystemService;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.actions.layout.ActionPositionFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.BookmarkPolicyFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFaFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.DescribedAsFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.HiddenFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.NamedFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.PromptStyleFacetForActionXml;
import org.apache.isis.core.metamodel.facets.actions.layout.RedirectFacetFromActionXml;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacet;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.facets.collections.layout.CssClassFacetForCollectionXml;
import org.apache.isis.core.metamodel.facets.collections.layout.DefaultViewFacetForCollectionXml;
import org.apache.isis.core.metamodel.facets.collections.layout.DescribedAsFacetForCollectionXml;
import org.apache.isis.core.metamodel.facets.collections.layout.HiddenFacetForCollectionXml;
import org.apache.isis.core.metamodel.facets.collections.layout.NamedFacetForCollectionXml;
import org.apache.isis.core.metamodel.facets.collections.layout.PagedFacetForCollectionXml;
import org.apache.isis.core.metamodel.facets.collections.layout.SortedByFacetForCollectionXml;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.core.metamodel.facets.members.order.annotprop.MemberOrderFacetXml;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.BookmarkPolicyFacetForDomainObjectXml;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.CssClassFaFacetForDomainObjectXml;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.CssClassFacetForDomainObjectXml;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.DescribedAsFacetForDomainObjectXml;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.NamedFacetForDomainObjectXml;
import org.apache.isis.core.metamodel.facets.object.domainobjectlayout.PluralFacetForDomainObjectXml;
import org.apache.isis.core.metamodel.facets.object.paged.PagedFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.CssClassFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.DescribedAsFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.HiddenFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.LabelAtFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.MultiLineFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.NamedFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.PromptStyleFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.RenderedAdjustedFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.TypicalLengthFacetForPropertyXml;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.UnchangingFacetForPropertyXml;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GridSystemServiceAbstract<G extends Grid>
implements GridSystemService<G> {
    private static final Logger LOG = LoggerFactory.getLogger(GridSystemServiceAbstract.class);
    private final Class<G> gridImplementation;
    private final String tns;
    private final String schemaLocation;
    @Inject
    protected SpecificationLoader specificationLoader;
    @Inject
    protected TranslationService translationService;
    @Inject
    protected JaxbService jaxbService;
    @Inject
    protected MessageService messageService;

    public GridSystemServiceAbstract(Class<G> gridImplementation, String tns, String schemaLocation) {
        this.gridImplementation = gridImplementation;
        this.tns = tns;
        this.schemaLocation = schemaLocation;
    }

    @Programmatic
    public Class<G> gridImplementation() {
        return this.gridImplementation;
    }

    @Programmatic
    public String tns() {
        return this.tns;
    }

    @Programmatic
    public String schemaLocation() {
        return this.schemaLocation;
    }

    @Programmatic
    public void normalize(G grid, Class<?> domainClass) {
        if (!this.gridImplementation.isAssignableFrom(grid.getClass())) {
            return;
        }
        boolean valid = this.validateAndNormalize((Grid)grid, domainClass);
        if (valid) {
            this.overwriteFacets(grid, domainClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Grid:\n\n{}\n\n", (Object)this.jaxbService.toXml(grid));
            }
        } else {
            if (_Context.isPrototyping()) {
                this.messageService.warnUser("Grid metadata errors for " + grid.getDomainClass().getName() + "; check the error log");
            }
            LOG.error("Grid metadata errors:\n\n{}\n\n", (Object)this.jaxbService.toXml(grid));
        }
    }

    protected abstract boolean validateAndNormalize(Grid var1, Class<?> var2);

    protected void overwriteFacets(G fcGrid, Class<?> domainClass) {
        final ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(domainClass);
        final Map<String, OneToOneAssociation> oneToOneAssociationById = ObjectMember.Util.mapById(GridSystemServiceAbstract.getOneToOneAssociations(objectSpec));
        final Map<String, OneToManyAssociation> oneToManyAssociationById = ObjectMember.Util.mapById(GridSystemServiceAbstract.getOneToManyAssociations(objectSpec));
        final Map<String, ObjectAction> objectActionById = ObjectMember.Util.mapById(objectSpec.streamObjectActions(Contributed.INCLUDED));
        final AtomicInteger propertySequence = new AtomicInteger(0);
        fcGrid.visit((Grid.Visitor)new Grid.VisitorAdapter(){
            private int collectionSequence = 1;
            private int actionDomainObjectSequence = 1;
            private int actionPropertyGroupSequence = 1;
            private int actionPropertySequence = 1;
            private int actionCollectionSequence = 1;

            public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                FacetUtil.addOrReplaceFacet(BookmarkPolicyFacetForDomainObjectXml.create(domainObjectLayoutData, objectSpec));
                FacetUtil.addOrReplaceFacet(CssClassFacetForDomainObjectXml.create(domainObjectLayoutData, objectSpec));
                FacetUtil.addOrReplaceFacet(CssClassFaFacetForDomainObjectXml.create(domainObjectLayoutData, objectSpec));
                FacetUtil.addOrReplaceFacet(DescribedAsFacetForDomainObjectXml.create(domainObjectLayoutData, objectSpec));
                FacetUtil.addOrReplaceFacet(NamedFacetForDomainObjectXml.create(domainObjectLayoutData, objectSpec));
                FacetUtil.addOrReplaceFacet(PluralFacetForDomainObjectXml.create(domainObjectLayoutData, objectSpec));
            }

            public void visit(ActionLayoutData actionLayoutData) {
                int memberOrderSequence;
                ActionLayoutDataOwner actionLayoutDataOwner = actionLayoutData.getOwner();
                ObjectAction objectAction = (ObjectAction)objectActionById.get(actionLayoutData.getId());
                if (objectAction == null) {
                    return;
                }
                String memberOrderName = null;
                if (actionLayoutDataOwner instanceof FieldSet) {
                    FieldSet fieldSet = (FieldSet)actionLayoutDataOwner;
                    List properties = fieldSet.getProperties();
                    for (PropertyLayoutData propertyLayoutData : properties) {
                        String propertyId = propertyLayoutData.getId();
                        if (!oneToOneAssociationById.containsKey(propertyId)) continue;
                        memberOrderName = propertyLayoutData.getId();
                        break;
                    }
                    memberOrderSequence = this.actionPropertyGroupSequence++;
                } else if (actionLayoutDataOwner instanceof PropertyLayoutData) {
                    PropertyLayoutData propertyLayoutData = (PropertyLayoutData)actionLayoutDataOwner;
                    memberOrderName = propertyLayoutData.getId();
                    memberOrderSequence = this.actionPropertySequence++;
                } else if (actionLayoutDataOwner instanceof CollectionLayoutData) {
                    CollectionLayoutData collectionLayoutData = (CollectionLayoutData)actionLayoutDataOwner;
                    memberOrderName = collectionLayoutData.getId();
                    memberOrderSequence = this.actionCollectionSequence++;
                } else {
                    memberOrderName = null;
                    memberOrderSequence = this.actionDomainObjectSequence++;
                }
                if (memberOrderName != null) {
                    FacetUtil.addOrReplaceFacet(new MemberOrderFacetXml(memberOrderName, "" + memberOrderSequence, GridSystemServiceAbstract.this.translationService, objectAction));
                }
                if (actionLayoutDataOwner instanceof FieldSet) {
                    if (actionLayoutData.getPosition() == null || actionLayoutData.getPosition() == ActionLayout.Position.BELOW || actionLayoutData.getPosition() == ActionLayout.Position.RIGHT) {
                        actionLayoutData.setPosition(ActionLayout.Position.PANEL);
                    }
                } else if (actionLayoutDataOwner instanceof PropertyLayoutData) {
                    if (actionLayoutData.getPosition() == null || actionLayoutData.getPosition() == ActionLayout.Position.PANEL_DROPDOWN || actionLayoutData.getPosition() == ActionLayout.Position.PANEL) {
                        actionLayoutData.setPosition(ActionLayout.Position.BELOW);
                    }
                } else {
                    actionLayoutData.setPosition(null);
                }
                FacetUtil.addOrReplaceFacet(ActionPositionFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(BookmarkPolicyFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(CssClassFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(CssClassFaFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(DescribedAsFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(HiddenFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(NamedFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(PromptStyleFacetForActionXml.create(actionLayoutData, objectAction));
                FacetUtil.addOrReplaceFacet(RedirectFacetFromActionXml.create(actionLayoutData, objectAction));
            }

            public void visit(PropertyLayoutData propertyLayoutData) {
                OneToOneAssociation oneToOneAssociation = (OneToOneAssociation)oneToOneAssociationById.get(propertyLayoutData.getId());
                if (oneToOneAssociation == null) {
                    return;
                }
                FacetUtil.addOrReplaceFacet(CssClassFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(DescribedAsFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(HiddenFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(LabelAtFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(MultiLineFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(NamedFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(PromptStyleFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(RenderedAdjustedFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(UnchangingFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FacetUtil.addOrReplaceFacet(TypicalLengthFacetForPropertyXml.create(propertyLayoutData, oneToOneAssociation));
                FieldSet fieldSet = propertyLayoutData.getOwner();
                String groupName = fieldSet.getName();
                String sequence = "" + propertySequence.incrementAndGet();
                FacetUtil.addOrReplaceFacet(new MemberOrderFacetXml(groupName, sequence, GridSystemServiceAbstract.this.translationService, oneToOneAssociation));
            }

            public void visit(CollectionLayoutData collectionLayoutData) {
                OneToManyAssociation oneToManyAssociation = (OneToManyAssociation)oneToManyAssociationById.get(collectionLayoutData.getId());
                if (oneToManyAssociation == null) {
                    return;
                }
                FacetUtil.addOrReplaceFacet(CssClassFacetForCollectionXml.create(collectionLayoutData, oneToManyAssociation));
                FacetUtil.addOrReplaceFacet(DefaultViewFacetForCollectionXml.create(collectionLayoutData, oneToManyAssociation));
                FacetUtil.addOrReplaceFacet(DescribedAsFacetForCollectionXml.create(collectionLayoutData, oneToManyAssociation));
                FacetUtil.addOrReplaceFacet(HiddenFacetForCollectionXml.create(collectionLayoutData, oneToManyAssociation));
                FacetUtil.addOrReplaceFacet(NamedFacetForCollectionXml.create(collectionLayoutData, oneToManyAssociation));
                FacetUtil.addOrReplaceFacet(PagedFacetForCollectionXml.create(collectionLayoutData, oneToManyAssociation));
                FacetUtil.addOrReplaceFacet(SortedByFacetForCollectionXml.create(collectionLayoutData, oneToManyAssociation));
                String groupName = collectionLayoutData.getId();
                String sequence = "" + this.collectionSequence++;
                FacetUtil.addOrReplaceFacet(new MemberOrderFacetXml(groupName, sequence, GridSystemServiceAbstract.this.translationService, oneToManyAssociation));
            }
        });
    }

    protected static Stream<OneToOneAssociation> getOneToOneAssociations(ObjectSpecification objectSpec) {
        Stream<ObjectAssociation> associations = objectSpec.streamAssociations(Contributed.INCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
        return (Stream)_Casts.uncheckedCast(associations);
    }

    protected static Stream<OneToManyAssociation> getOneToManyAssociations(ObjectSpecification objectSpec) {
        Stream<ObjectAssociation> associations = objectSpec.streamAssociations(Contributed.INCLUDED).filter(ObjectAssociation.Predicates.COLLECTIONS);
        return (Stream)_Casts.uncheckedCast(associations);
    }

    protected static <T> Tuple<List<T>> surplusAndMissing(Collection<T> first, Collection<T> second) {
        ArrayList firstNotSecond = _Lists.newArrayList(first);
        firstNotSecond.removeAll(second);
        ArrayList secondNotFirst = _Lists.newArrayList(second);
        secondNotFirst.removeAll(first);
        return Tuple.of(firstNotSecond, secondNotFirst);
    }

    @Programmatic
    public void complete(G grid, Class<?> domainClass) {
        this.normalize(grid, domainClass);
        final ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(domainClass);
        grid.visit((Grid.Visitor)new Grid.VisitorAdapter(){

            public void visit(ActionLayoutData actionLayoutData) {
                ObjectAction objectAction = objectSpec.getObjectAction(actionLayoutData.getId());
                GridSystemServiceAbstract.this.setBookmarkingIfAny((HasBookmarking)actionLayoutData, objectAction);
                GridSystemServiceAbstract.this.setCssClassIfAny((HasCssClass)actionLayoutData, objectAction);
                GridSystemServiceAbstract.this.setCssClassFaIfAny((HasCssClassFa)actionLayoutData, objectAction);
                GridSystemServiceAbstract.this.setDescribedAsIfAny((HasDescribedAs)actionLayoutData, objectAction);
                GridSystemServiceAbstract.this.setHiddenIfAny((HasHidden)actionLayoutData, objectAction);
                GridSystemServiceAbstract.this.setNamedIfAny((HasNamed)actionLayoutData, objectAction);
                GridSystemServiceAbstract.this.setActionPositionIfAny(actionLayoutData, objectAction);
            }

            public void visit(CollectionLayoutData collectionLayoutData) {
                ObjectAssociation collection = objectSpec.getAssociation(collectionLayoutData.getId());
                GridSystemServiceAbstract.this.setCssClassIfAny((HasCssClass)collectionLayoutData, collection);
                GridSystemServiceAbstract.this.setDefaultViewIfAny(collectionLayoutData, collection);
                GridSystemServiceAbstract.this.setDescribedAsIfAny((HasDescribedAs)collectionLayoutData, collection);
                GridSystemServiceAbstract.this.setHiddenIfAny((HasHidden)collectionLayoutData, collection);
                GridSystemServiceAbstract.this.setNamedIfAny((HasNamed)collectionLayoutData, collection);
                GridSystemServiceAbstract.this.setPagedIfAny(collectionLayoutData, collection);
                GridSystemServiceAbstract.this.setSortedByIfAny(collectionLayoutData, collection);
            }

            public void visit(PropertyLayoutData propertyLayoutData) {
                ObjectAssociation property = objectSpec.getAssociation(propertyLayoutData.getId());
                GridSystemServiceAbstract.this.setCssClassIfAny((HasCssClass)propertyLayoutData, property);
                GridSystemServiceAbstract.this.setDescribedAsIfAny((HasDescribedAs)propertyLayoutData, property);
                GridSystemServiceAbstract.this.setHiddenIfAny((HasHidden)propertyLayoutData, property);
                GridSystemServiceAbstract.this.setNamedIfAny((HasNamed)propertyLayoutData, property);
                GridSystemServiceAbstract.this.setLabelPositionIfAny(propertyLayoutData, property);
                GridSystemServiceAbstract.this.setMultiLineIfAny(propertyLayoutData, property);
                GridSystemServiceAbstract.this.setRenderedAsDayBeforeIfAny(propertyLayoutData, property);
                GridSystemServiceAbstract.this.setTypicalLengthIfAny(propertyLayoutData, property);
            }

            public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                GridSystemServiceAbstract.this.setBookmarkingIfAny((HasBookmarking)domainObjectLayoutData, objectSpec);
                GridSystemServiceAbstract.this.setCssClassIfAny((HasCssClass)domainObjectLayoutData, objectSpec);
                GridSystemServiceAbstract.this.setCssClassFaIfAny((HasCssClassFa)domainObjectLayoutData, objectSpec);
                GridSystemServiceAbstract.this.setDescribedAsIfAny((HasDescribedAs)domainObjectLayoutData, objectSpec);
                GridSystemServiceAbstract.this.setNamedIfAny((HasNamed)domainObjectLayoutData, objectSpec);
                GridSystemServiceAbstract.this.setPluralIfAny(domainObjectLayoutData, objectSpec);
            }
        });
    }

    private static boolean isDoOp(Facet facet) {
        return facet != null && !facet.isNoop();
    }

    protected void setBookmarkingIfAny(HasBookmarking hasBookmarking, FacetHolder facetHolder) {
        BookmarkPolicy bookmarking;
        BookmarkPolicyFacet bookmarkPolicyFacet = facetHolder.getFacet(BookmarkPolicyFacet.class);
        if (GridSystemServiceAbstract.isDoOp(bookmarkPolicyFacet) && (bookmarking = (BookmarkPolicy)bookmarkPolicyFacet.value()) != null) {
            hasBookmarking.setBookmarking(bookmarking);
        }
    }

    protected void setCssClassIfAny(HasCssClass hasCssClass, FacetHolder facetHolder) {
        CssClassFacet cssClassFacet = facetHolder.getFacet(CssClassFacet.class);
        if (GridSystemServiceAbstract.isDoOp(cssClassFacet)) {
            try {
                String cssClass = cssClassFacet.cssClass(null);
                if (!_Strings.isNullOrEmpty((CharSequence)cssClass)) {
                    hasCssClass.setCssClass(cssClass);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setCssClassFaIfAny(HasCssClassFa hasCssClassFa, FacetHolder facetHolder) {
        CssClassFaFacet cssClassFaFacet = facetHolder.getFacet(CssClassFaFacet.class);
        if (GridSystemServiceAbstract.isDoOp(cssClassFaFacet)) {
            String cssClassFa = (String)cssClassFaFacet.value();
            CssClassFaPosition position = cssClassFaFacet.getPosition();
            if (!_Strings.isNullOrEmpty((CharSequence)cssClassFa)) {
                hasCssClassFa.setCssClassFa(cssClassFa);
                hasCssClassFa.setCssClassFaPosition(position.toActionLayoutPosition());
            }
        }
    }

    protected void setDefaultViewIfAny(CollectionLayoutData collectionLayoutData, FacetHolder facetHolder) {
        String defaultView;
        DefaultViewFacet defaultViewFacet = facetHolder.getFacet(DefaultViewFacet.class);
        if (GridSystemServiceAbstract.isDoOp(defaultViewFacet) && !_Strings.isNullOrEmpty((CharSequence)(defaultView = (String)defaultViewFacet.value()))) {
            collectionLayoutData.setDefaultView(defaultView);
        }
    }

    protected void setDescribedAsIfAny(HasDescribedAs hasDescribedAs, FacetHolder facetHolder) {
        String describedAs;
        DescribedAsFacet describedAsFacet = facetHolder.getFacet(DescribedAsFacet.class);
        if (GridSystemServiceAbstract.isDoOp(describedAsFacet) && !_Strings.isNullOrEmpty((CharSequence)(describedAs = (String)describedAsFacet.value()))) {
            hasDescribedAs.setDescribedAs(describedAs);
        }
    }

    protected void setHiddenIfAny(HasHidden hasHidden, FacetHolder facetHolder) {
        Where where;
        HiddenFacet hiddenFacet = facetHolder.getFacet(HiddenFacet.class);
        if (GridSystemServiceAbstract.isDoOp(hiddenFacet) && (where = hiddenFacet.where()) != null) {
            hasHidden.setHidden(where);
        }
    }

    protected void setLabelPositionIfAny(PropertyLayoutData propertyLayoutData, FacetHolder facetHolder) {
        LabelPosition labelPosition;
        LabelAtFacet labelAtFacet = facetHolder.getFacet(LabelAtFacet.class);
        if (GridSystemServiceAbstract.isDoOp(labelAtFacet) && (labelPosition = labelAtFacet.label()) != null) {
            propertyLayoutData.setLabelPosition(labelPosition);
        }
    }

    protected void setMultiLineIfAny(PropertyLayoutData propertyLayoutData, FacetHolder facetHolder) {
        int numberOfLines;
        MultiLineFacet multiLineFacet = facetHolder.getFacet(MultiLineFacet.class);
        if (GridSystemServiceAbstract.isDoOp(multiLineFacet) && (numberOfLines = multiLineFacet.numberOfLines()) > 0) {
            propertyLayoutData.setMultiLine(Integer.valueOf(numberOfLines));
        }
    }

    protected void setNamedIfAny(HasNamed hasNamed, FacetHolder facetHolder) {
        NamedFacet namedFacet = facetHolder.getFacet(NamedFacet.class);
        if (GridSystemServiceAbstract.isDoOp(namedFacet)) {
            boolean escaped;
            String named = namedFacet.value();
            if (!_Strings.isNullOrEmpty((CharSequence)named)) {
                hasNamed.setNamed(named);
            }
            if (!(escaped = namedFacet.escaped())) {
                hasNamed.setNamedEscaped(Boolean.valueOf(escaped));
            }
        }
    }

    protected void setPagedIfAny(CollectionLayoutData collectionLayoutData, FacetHolder facetHolder) {
        int value;
        PagedFacet pagedFacet = facetHolder.getFacet(PagedFacet.class);
        if (GridSystemServiceAbstract.isDoOp(pagedFacet) && (value = pagedFacet.value()) > 0) {
            collectionLayoutData.setPaged(Integer.valueOf(value));
        }
    }

    protected void setPluralIfAny(DomainObjectLayoutData domainObjectLayoutData, FacetHolder facetHolder) {
        String plural;
        PluralFacet pluralFacet = facetHolder.getFacet(PluralFacet.class);
        if (GridSystemServiceAbstract.isDoOp(pluralFacet) && !_Strings.isNullOrEmpty((CharSequence)(plural = (String)pluralFacet.value()))) {
            domainObjectLayoutData.setPlural(plural);
        }
    }

    protected void setActionPositionIfAny(ActionLayoutData actionLayoutData, FacetHolder facetHolder) {
        ActionLayout.Position position;
        ActionPositionFacet actionPositionFacet = facetHolder.getFacet(ActionPositionFacet.class);
        if (GridSystemServiceAbstract.isDoOp(actionPositionFacet) && (position = actionPositionFacet.position()) != null) {
            actionLayoutData.setPosition(position);
        }
    }

    protected void setRenderedAsDayBeforeIfAny(PropertyLayoutData propertyLayoutData, FacetHolder facetHolder) {
        RenderedAdjustedFacet renderedAdjustedFacet = facetHolder.getFacet(RenderedAdjustedFacet.class);
        if (GridSystemServiceAbstract.isDoOp(renderedAdjustedFacet)) {
            int adjusted = renderedAdjustedFacet.value();
            propertyLayoutData.setRenderDay(adjusted != 0 ? RenderDay.AS_DAY_BEFORE : RenderDay.AS_DAY);
        }
    }

    protected void setSortedByIfAny(CollectionLayoutData collectionLayoutData, FacetHolder facetHolder) {
        Class className;
        SortedByFacet sortedByFacet = facetHolder.getFacet(SortedByFacet.class);
        if (GridSystemServiceAbstract.isDoOp(sortedByFacet) && (className = (Class)sortedByFacet.value()) != null) {
            collectionLayoutData.setSortedBy(className.getCanonicalName());
        }
    }

    protected void setTypicalLengthIfAny(PropertyLayoutData propertyLayoutData, FacetHolder facetHolder) {
        int typicalLength;
        TypicalLengthFacet typicalLengthFacet = facetHolder.getFacet(TypicalLengthFacet.class);
        if (GridSystemServiceAbstract.isDoOp(typicalLengthFacet) && (typicalLength = typicalLengthFacet.value()) > 0) {
            propertyLayoutData.setTypicalLength(Integer.valueOf(typicalLength));
        }
    }

    @Programmatic
    public void minimal(G grid, Class<?> domainClass) {
        this.normalize(grid, domainClass);
        grid.visit((Grid.Visitor)new Grid.VisitorAdapter(){

            public void visit(ActionLayoutData actionLayoutData) {
                actionLayoutData.getOwner().getActions().remove(actionLayoutData);
            }

            public void visit(CollectionLayoutData collectionLayoutData) {
                collectionLayoutData.getOwner().getCollections().remove(collectionLayoutData);
            }

            public void visit(PropertyLayoutData propertyLayoutData) {
                propertyLayoutData.getOwner().getProperties().remove(propertyLayoutData);
            }

            public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                DomainObjectLayoutDataOwner owner = domainObjectLayoutData.getOwner();
                owner.setDomainObject(new DomainObjectLayoutData());
            }
        });
    }

    protected static class Tuple<T> {
        public final T first;
        public final T second;

        private Tuple(T first, T second) {
            this.first = first;
            this.second = second;
        }

        public static <T> Tuple<T> of(T first, T second) {
            return new Tuple<T>(first, second);
        }
    }
}

