/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.services.grid.GridLoaderService2;
import org.apache.isis.applib.services.grid.GridService2;
import org.apache.isis.applib.services.grid.GridSystemService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class GridServiceDefault
implements GridService2 {
    public static final String COMPONENT_TNS = "http://isis.apache.org/applib/layout/component";
    public static final String COMPONENT_SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/component/component.xsd";
    public static final String LINKS_TNS = "http://isis.apache.org/applib/layout/links";
    public static final String LINKS_SCHEMA_LOCATION = "http://isis.apache.org/applib/layout/links/links.xsd";
    private List<GridSystemService<?>> filteredGridSystemServices;
    @Inject
    GridLoaderService2 gridLoaderService;
    @Inject
    List<GridSystemService<?>> gridSystemServices;

    public boolean supportsReloading() {
        return this.gridLoaderService.supportsReloading();
    }

    public void remove(Class<?> domainClass) {
        this.gridLoaderService.remove(domainClass);
    }

    @Programmatic
    public boolean existsFor(Class<?> domainClass) {
        return this.gridLoaderService.existsFor(domainClass);
    }

    @Programmatic
    public Grid load(Class<?> domainClass) {
        return this.gridLoaderService.load(domainClass);
    }

    @Programmatic
    public Grid load(Class<?> domainClass, String layout) {
        return this.gridLoaderService.load(domainClass, layout);
    }

    @Programmatic
    public Grid defaultGridFor(Class<?> domainClass) {
        for (GridSystemService<?> gridSystemService : this.gridSystemServices()) {
            Grid grid = gridSystemService.defaultGrid(domainClass);
            if (grid == null) continue;
            return grid;
        }
        throw new IllegalStateException("No GridSystemService available to create grid for '" + domainClass.getName() + "'");
    }

    public Grid normalize(Grid grid) {
        if (grid.isNormalized()) {
            return grid;
        }
        Class domainClass = grid.getDomainClass();
        for (GridSystemService<?> gridSystemService : this.gridSystemServices()) {
            gridSystemService.normalize((Grid)_Casts.uncheckedCast((Object)grid), domainClass);
        }
        String tnsAndSchemaLocation = this.tnsAndSchemaLocation(grid);
        grid.setTnsAndSchemaLocation(tnsAndSchemaLocation);
        grid.setNormalized(true);
        return grid;
    }

    @Programmatic
    public Grid complete(Grid grid) {
        Class domainClass = grid.getDomainClass();
        for (GridSystemService<?> gridSystemService : this.gridSystemServices()) {
            gridSystemService.complete((Grid)_Casts.uncheckedCast((Object)grid), domainClass);
        }
        return grid;
    }

    @Programmatic
    public Grid minimal(Grid grid) {
        Class domainClass = grid.getDomainClass();
        for (GridSystemService<?> gridSystemService : this.gridSystemServices()) {
            gridSystemService.minimal((Grid)_Casts.uncheckedCast((Object)grid), domainClass);
        }
        return grid;
    }

    @Programmatic
    public String tnsAndSchemaLocation(Grid grid) {
        ArrayList parts = _Lists.newArrayList();
        parts.add(COMPONENT_TNS);
        parts.add(COMPONENT_SCHEMA_LOCATION);
        parts.add(LINKS_TNS);
        parts.add(LINKS_SCHEMA_LOCATION);
        for (GridSystemService<?> gridSystemService : this.gridSystemServices) {
            Class gridImpl = gridSystemService.gridImplementation();
            if (!gridImpl.isAssignableFrom(grid.getClass())) continue;
            parts.add(gridSystemService.tns());
            parts.add(gridSystemService.schemaLocation());
        }
        return parts.stream().collect(Collectors.joining(""));
    }

    @Programmatic
    protected List<GridSystemService<?>> gridSystemServices() {
        if (this.filteredGridSystemServices == null) {
            ArrayList services = _Lists.newArrayList();
            for (GridSystemService<?> gridSystemService : this.gridSystemServices) {
                Class gridImplementation = gridSystemService.gridImplementation();
                boolean seenBefore = _NullSafe.stream((Collection)services).anyMatch(systemService -> systemService.gridImplementation() == gridImplementation);
                if (seenBefore) continue;
                services.add(gridSystemService);
            }
            this.filteredGridSystemServices = services;
        }
        return this.filteredGridSystemServices;
    }
}

