/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class FactoryServiceInternalDefault
implements FactoryService {
    @Inject
    SpecificationLoader specificationLoader;
    @Inject
    ServiceRegistry serviceRegistry;
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    @Programmatic
    public <T> T instantiate(Class<T> domainClass) {
        ObjectSpecification spec = this.specificationLoader.loadSpecification(domainClass);
        ObjectAdapter adapter = this.doCreateTransientInstance(spec);
        return (T)adapter.getPojo();
    }

    protected ObjectAdapter doCreateTransientInstance(ObjectSpecification spec) {
        return this.persistenceSessionServiceInternal.createTransientInstance(spec);
    }

    @Programmatic
    public <T> T m(Class<T> mixinClass, Object mixedIn) {
        return this.mixin(mixinClass, mixedIn);
    }

    @Programmatic
    public <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        Constructor<?>[] constructors;
        ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(mixinClass);
        MixinFacet mixinFacet = objectSpec.getFacet(MixinFacet.class);
        if (mixinFacet == null) {
            throw new NonRecoverableException("Class '" + mixinClass.getName() + " is not a mixin");
        }
        if (!mixinFacet.isMixinFor(mixedIn.getClass())) {
            throw new NonRecoverableException("Mixin class '" + mixinClass.getName() + " is not a mixin for supplied object '" + mixedIn + "'");
        }
        for (Constructor<?> constructor : constructors = mixinClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(mixedIn.getClass())) continue;
            try {
                Object mixin = constructor.newInstance(mixedIn);
                return (T)_Casts.uncheckedCast((Object)this.serviceRegistry.injectServicesInto(mixin));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new NonRecoverableException((Throwable)e);
            }
        }
        throw new NonRecoverableException(String.format("Failed to locate constructor in %s to instantiate using %s", mixinClass.getName(), mixedIn));
    }
}

