/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.appfeat;

import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;

public enum ApplicationFeatureType {
    PACKAGE{

        @Override
        void init(ApplicationFeatureId feature, String fullyQualifiedName) {
            feature.setPackageName(fullyQualifiedName);
            feature.setClassName(null);
            feature.setMemberName(null);
            feature.type = this;
        }
    }
    ,
    CLASS{

        @Override
        void init(ApplicationFeatureId feature, String fullyQualifiedName) {
            int i = fullyQualifiedName.lastIndexOf(".");
            if (i != -1) {
                feature.setPackageName(fullyQualifiedName.substring(0, i));
                feature.setClassName(fullyQualifiedName.substring(i + 1));
            } else {
                feature.setPackageName("");
                feature.setClassName(fullyQualifiedName);
            }
            feature.setMemberName(null);
            feature.type = this;
        }
    }
    ,
    MEMBER{

        @Override
        void init(ApplicationFeatureId feature, String fullyQualifiedName) {
            int i = fullyQualifiedName.lastIndexOf("#");
            if (i == -1) {
                throw new IllegalArgumentException("Malformed, expected a '#': " + fullyQualifiedName);
            }
            String className = fullyQualifiedName.substring(0, i);
            String memberName = fullyQualifiedName.substring(i + 1);
            CLASS.init(feature, className);
            feature.setMemberName(memberName);
            feature.type = this;
        }
    };


    public boolean hideClassName() {
        return this == PACKAGE;
    }

    public boolean hideMember() {
        return this == PACKAGE || this == CLASS;
    }

    abstract void init(ApplicationFeatureId var1, String var2);

    static void ensurePackage(ApplicationFeatureId feature) {
        if (feature.type != PACKAGE) {
            throw new IllegalStateException("Can only be called for a package; " + feature.toString());
        }
    }

    static void ensurePackageOrClass(ApplicationFeatureId applicationFeatureId) {
        if (applicationFeatureId.type != PACKAGE && applicationFeatureId.type != CLASS) {
            throw new IllegalStateException("Can only be called for a package or a class; " + applicationFeatureId.toString());
        }
    }

    static void ensureClass(ApplicationFeatureId feature) {
        if (feature.type != CLASS) {
            throw new IllegalStateException("Can only be called for a class; " + feature.toString());
        }
    }

    static void ensureMember(ApplicationFeatureId feature) {
        if (feature.type != MEMBER) {
            throw new IllegalStateException("Can only be called for a member; " + feature.toString());
        }
    }

    public String toString() {
        return StringExtensions.capitalize(this.name());
    }
}

