/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.progmodel;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.isis.commons.internal.collections._Multimaps;
import org.apache.isis.core.metamodel.facets.FacetFactory;

public interface ProgrammingModelPlugin {
    public static FactoryCollector collector() {
        return new FactoryCollector(){
            final _Multimaps.SetMultimap<FacetFactoryCategory, FacetFactory> factoriesByCategory = _Multimaps.newSetMultimap();

            @Override
            public void addFactory(FacetFactory factory, FacetFactoryCategory category) {
                Objects.requireNonNull(factory);
                Objects.requireNonNull(category);
                this.factoriesByCategory.putElement((Object)category, (Object)factory);
            }

            @Override
            public Set<FacetFactory> getFactories(FacetFactoryCategory category) {
                if (category == null) {
                    return Collections.emptySet();
                }
                return Collections.unmodifiableSet((Set)this.factoriesByCategory.getOrDefault((Object)category, Collections.emptySet()));
            }
        };
    }

    public void plugin(FactoryCollector var1);

    public static interface FactoryCollector {
        public void addFactory(FacetFactory var1, FacetFactoryCategory var2);

        public Set<FacetFactory> getFactories(FacetFactoryCategory var1);
    }

    public static enum FacetFactoryCategory {
        VALUE;

    }
}

