/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.postprocessors.param;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.isis.applib.ApplicationException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacetAbstract;

public class ActionParameterDefaultsFacetFromAssociatedCollection
extends ActionParameterDefaultsFacetAbstract {
    private static ThreadLocal<List<Object>> selectedPojos = new ThreadLocal<List<Object>>(){

        @Override
        protected List<Object> initialValue() {
            return Collections.emptyList();
        }
    };

    public static <T> T withSelected(List<Object> objects, SerializableRunnable<T> callable) {
        try {
            selectedPojos.set(objects);
            Object v = callable.call();
            return (T)v;
        }
        catch (Exception e) {
            throw new ApplicationException((Throwable)e);
        }
        finally {
            selectedPojos.set(Collections.emptyList());
        }
    }

    public ActionParameterDefaultsFacetFromAssociatedCollection(FacetHolder holder) {
        super(holder);
    }

    @Override
    public Object getDefault(ObjectAdapter target, List<ObjectAdapter> argumentsIfAvailable) {
        return selectedPojos.get();
    }

    public static interface SerializableRunnable<T>
    extends Callable<T>,
    Serializable {
    }
}

