/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.isis.applib.services.wrapper.events.InteractionEvent;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.DecoratingFacet;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.interactions.DisablingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.HidingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidatingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;

public final class InteractionUtils {
    private InteractionUtils() {
    }

    public static InteractionResult isVisibleResult(FacetHolder facetHolder, VisibilityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        Stream<Facet> facets = facetHolder.streamFacets().filter(InteractionUtils.isA(HidingInteractionAdvisor.class));
        facets.forEach(facet -> {
            HidingInteractionAdvisor advisor = (HidingInteractionAdvisor)facet;
            result.advise(advisor.hides(context), advisor);
        });
        return result;
    }

    public static InteractionResult isUsableResult(FacetHolder facetHolder, UsabilityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        Stream<Facet> facets = facetHolder.streamFacets().filter(InteractionUtils.isA(DisablingInteractionAdvisor.class));
        facets.forEach(facet -> {
            DisablingInteractionAdvisor advisor = (DisablingInteractionAdvisor)facet;
            String disables = advisor.disables(context);
            result.advise(disables, advisor);
        });
        return result;
    }

    public static InteractionResult isValidResult(FacetHolder facetHolder, ValidityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        Stream<Facet> facets = facetHolder.streamFacets().filter(InteractionUtils.isA(ValidatingInteractionAdvisor.class));
        facets.forEach(facet -> {
            ValidatingInteractionAdvisor advisor = (ValidatingInteractionAdvisor)facet;
            result.advise(advisor.invalidates(context), advisor);
        });
        return result;
    }

    public static InteractionResultSet isValidResultSet(FacetHolder facetHolder, ValidityContext<?> context, InteractionResultSet resultSet) {
        return resultSet.add(InteractionUtils.isValidResult(facetHolder, context));
    }

    static Predicate<Facet> isA(final Class<?> superClass) {
        return new Predicate<Facet>(){

            @Override
            public boolean test(Facet facet) {
                if (facet instanceof DecoratingFacet) {
                    DecoratingFacet decoratingFacet = (DecoratingFacet)((Object)facet);
                    return this.test((Facet)decoratingFacet.getDecoratedFacet());
                }
                return superClass.isAssignableFrom(facet.getClass());
            }
        };
    }
}

