/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.time;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.ValueSemanticsProviderAbstractTemporal;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class TimeValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static final Object DEFAULT_VALUE = null;
    private static final int TYPICAL_LENGTH = 8;

    protected static void initFormats(Map<String, DateFormat> formats) {
        formats.put("iso_encoding", TimeValueSemanticsProviderAbstract.createDateEncodingFormat("HHmmssSSS"));
        formats.put("short", DateFormat.getTimeInstance(3));
    }

    public TimeValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, ServicesInjector context) {
        super("time", holder, adaptedClass, 8, ValueSemanticsProviderAndFacetAbstract.Immutability.NOT_IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, context);
        String formatRequired = this.getConfiguration().getString("isis.value.format.time");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    protected void clearFields(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
    }

    @Override
    protected String defaultFormat() {
        return "short";
    }

    @Override
    public String toString() {
        return "TimeValueSemanticsProvider: " + this.format;
    }

    @Override
    protected DateFormat format() {
        Locale locale = Locale.getDefault();
        DateFormat dateFormat = DateFormat.getTimeInstance(3, locale);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        return dateFormat;
    }

    @Override
    protected List<DateFormat> formatsToTry() {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        Locale locale = Locale.getDefault();
        formats.add(DateFormat.getTimeInstance(1, locale));
        formats.add(DateFormat.getTimeInstance(2, locale));
        formats.add(DateFormat.getTimeInstance(3, locale));
        formats.add(TimeValueSemanticsProviderAbstract.createDateFormat("HH:mm:ss.SSS"));
        formats.add(TimeValueSemanticsProviderAbstract.createDateFormat("HHmmssSSS"));
        formats.add(TimeValueSemanticsProviderAbstract.createDateFormat("HH:mm:ss"));
        formats.add(TimeValueSemanticsProviderAbstract.createDateFormat("HHmmss"));
        for (DateFormat format : formats) {
            format.setTimeZone(UTC_TIME_ZONE);
        }
        return formats;
    }
}

