/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.shortint;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.shortint.ShortValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class ShortValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Short>
implements ShortValueFacet {
    private static final Short DEFAULT_VALUE = 0;
    private static final int MAX_LENGTH = 6;
    private static final int TYPICAL_LENGTH = 6;
    private final NumberFormat format = this.determineNumberFormat("value.format.short");

    public static Class<? extends Facet> type() {
        return ShortValueFacet.class;
    }

    public ShortValueSemanticsProviderAbstract(FacetHolder holder, Class<Short> adaptedClass, ServicesInjector context) {
        super(ShortValueSemanticsProviderAbstract.type(), holder, adaptedClass, 6, 6, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected Short doParse(Object context, String entry) {
        try {
            return this.format.parse(entry).shortValue();
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a whole number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Short doRestore(String data) {
        return new Short(data);
    }

    @Override
    public ObjectAdapter createValue(Short value) {
        return this.getObjectAdapterProvider().adapterFor(value);
    }

    @Override
    public Short shortValue(ObjectAdapter object) {
        return (Short)(object == null ? null : object.getPojo());
    }

    @Override
    public String toString() {
        return "ShortValueSemanticsProvider: " + this.format;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("format", this.format);
    }
}

