/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejodalocal;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.isis.applib.adapters.EncodingException;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.datetimejodalocal.JodaLocalDateTimeUtil;
import org.apache.isis.core.metamodel.facets.value.datetimejodalocal.JodaLocalDateTimeValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaLocalDateTimeValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<LocalDateTime>
implements JodaLocalDateTimeValueFacet {
    public static final int MAX_LENGTH = 36;
    public static final int TYPICAL_LENGTH = 22;
    public static final String CFG_FORMAT_KEY = "isis.value.format.datetime";
    private static Map<String, DateTimeFormatter> NAMED_TITLE_FORMATTERS = _Maps.newHashMap();
    private static final ThreadLocal<String> OVERRIDE_TITLE_PATTERN;
    private static final List<DateTimeFormatter> PARSE_FORMATTERS;
    private static final LocalDateTime DEFAULT_VALUE;
    private final DateTimeFormatter encodingFormatter = ISODateTimeFormat.dateHourMinuteSecondMillis();
    private DateTimeFormatter titleStringFormatter;
    private String titleStringFormatNameOrPattern;

    @Deprecated
    public static void setFormat(String propertyType, String pattern) {
        JodaLocalDateTimeValueSemanticsProvider.setTitlePatternOverride(pattern);
    }

    public static void setTitlePatternOverride(String pattern) {
        OVERRIDE_TITLE_PATTERN.set(pattern);
    }

    public static Class<? extends Facet> type() {
        return JodaLocalDateTimeValueFacet.class;
    }

    public JodaLocalDateTimeValueSemanticsProvider() {
        this(null, null);
    }

    public JodaLocalDateTimeValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(JodaLocalDateTimeValueSemanticsProvider.type(), holder, LocalDateTime.class, 22, 36, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
        String configuredNameOrPattern = this.getConfiguration().getString(CFG_FORMAT_KEY, "medium").toLowerCase().trim();
        this.updateTitleStringFormatter(configuredNameOrPattern);
    }

    private void updateTitleStringFormatter(String titleStringFormatNameOrPattern) {
        this.titleStringFormatter = NAMED_TITLE_FORMATTERS.get(titleStringFormatNameOrPattern);
        if (this.titleStringFormatter == null) {
            this.titleStringFormatter = DateTimeFormat.forPattern((String)titleStringFormatNameOrPattern);
        }
        this.titleStringFormatNameOrPattern = titleStringFormatNameOrPattern;
    }

    @Override
    protected LocalDateTime doParse(String entry, Object context) {
        this.updateTitleStringFormatterIfOverridden();
        LocalDateTime contextDateTime = (LocalDateTime)context;
        String dateString = entry.trim().toUpperCase();
        if (dateString.startsWith("+") && contextDateTime != null) {
            return JodaLocalDateTimeUtil.relativeDateTime(contextDateTime, dateString, true);
        }
        if (dateString.startsWith("-") && contextDateTime != null) {
            return JodaLocalDateTimeUtil.relativeDateTime(contextDateTime, dateString, false);
        }
        return this.parseDateTime(dateString, contextDateTime);
    }

    private void updateTitleStringFormatterIfOverridden() {
        String overridePattern = OVERRIDE_TITLE_PATTERN.get();
        if (overridePattern == null || this.titleStringFormatNameOrPattern.equals(overridePattern)) {
            return;
        }
        this.updateTitleStringFormatter(overridePattern);
    }

    private LocalDateTime parseDateTime(String dateStr, Object original) {
        return JodaLocalDateTimeUtil.parseDate(dateStr, PARSE_FORMATTERS);
    }

    @Override
    public String titleString(Object value) {
        if (value == null) {
            return null;
        }
        LocalDateTime dateTime = (LocalDateTime)value;
        DateTimeFormatter f = this.titleStringFormatter.withLocale(Locale.getDefault());
        return JodaLocalDateTimeUtil.titleString(f, dateTime);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        LocalDateTime dateTime = (LocalDateTime)value;
        return JodaLocalDateTimeUtil.titleString(DateTimeFormat.forPattern((String)usingMask), dateTime);
    }

    @Override
    protected String doEncode(Object object) {
        LocalDateTime date = (LocalDateTime)object;
        return this.encode(date);
    }

    private synchronized String encode(LocalDateTime date) {
        return this.encodingFormatter.print((ReadablePartial)date);
    }

    @Override
    protected LocalDateTime doRestore(String data) {
        try {
            return this.parse(data);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException((Throwable)e);
        }
    }

    private synchronized LocalDateTime parse(String data) {
        return this.encodingFormatter.parseLocalDateTime(data);
    }

    @Override
    public final LocalDateTime dateValue(ObjectAdapter object) {
        return (LocalDateTime)(object == null ? null : object.getPojo());
    }

    @Override
    public final ObjectAdapter createValue(LocalDateTime date) {
        return this.getObjectAdapterProvider().adapterFor(date);
    }

    @Override
    public String toString() {
        return "JodaLocalDateTimeValueSemanticsProvider: " + this.titleStringFormatter;
    }

    static {
        NAMED_TITLE_FORMATTERS.put("iso_encoding", ISODateTimeFormat.basicDateTime());
        NAMED_TITLE_FORMATTERS.put("iso", ISODateTimeFormat.basicDateTimeNoMillis());
        NAMED_TITLE_FORMATTERS.put("long", DateTimeFormat.forStyle((String)"LL"));
        NAMED_TITLE_FORMATTERS.put("medium", DateTimeFormat.forStyle((String)"MM"));
        NAMED_TITLE_FORMATTERS.put("short", DateTimeFormat.forStyle((String)"SS"));
        OVERRIDE_TITLE_PATTERN = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return null;
            }
        };
        PARSE_FORMATTERS = _Lists.newArrayList();
        PARSE_FORMATTERS.add(DateTimeFormat.forStyle((String)"LL"));
        PARSE_FORMATTERS.add(DateTimeFormat.forStyle((String)"MM"));
        PARSE_FORMATTERS.add(DateTimeFormat.forStyle((String)"SS"));
        PARSE_FORMATTERS.add(ISODateTimeFormat.basicDateTimeNoMillis());
        PARSE_FORMATTERS.add(ISODateTimeFormat.basicDateTime());
        DEFAULT_VALUE = null;
    }
}

