/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.biginteger;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.biginteger.BigIntegerValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class BigIntegerValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<BigInteger>
implements BigIntegerValueFacet {
    private static final int TYPICAL_LENGTH = 10;
    private static final BigInteger DEFAULT_VALUE = BigInteger.valueOf(0L);
    private final NumberFormat format = this.determineNumberFormat("value.format.int");

    private static Class<? extends Facet> type() {
        return BigIntegerValueFacet.class;
    }

    public BigIntegerValueSemanticsProvider() {
        this(null, null);
    }

    public BigIntegerValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(BigIntegerValueSemanticsProvider.type(), holder, BigInteger.class, 10, -1, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected BigInteger doParse(Object context, String entry) {
        try {
            return new BigInteger(entry);
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not an integer " + entry, e);
        }
    }

    @Override
    public String titleString(Object object) {
        return this.titleString(this.format, object);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected BigInteger doRestore(String data) {
        return new BigInteger(data);
    }

    @Override
    public String toString() {
        return "BigIntegerValueSemanticsProvider: " + this.format;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("format", this.format);
    }
}

